<?php

namespace Eurostop\Stocks;

class SubmitAllocationActions
{

    /**
     * @var ArrayOfSubmittedAllocationAction $allocationActions
     */
    protected $allocationActions = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedAllocationAction $allocationActions
     * @param string $submissionReference
     */
    public function __construct($allocationActions, $submissionReference)
    {
      $this->allocationActions = $allocationActions;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedAllocationAction
     */
    public function getAllocationActions()
    {
      return $this->allocationActions;
    }

    /**
     * @param ArrayOfSubmittedAllocationAction $allocationActions
     * @return \Eurostop\Stocks\SubmitAllocationActions
     */
    public function setAllocationActions($allocationActions)
    {
      $this->allocationActions = $allocationActions;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitAllocationActions
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
