<?php

namespace Eurostop\Stocks;

class SubmitAllocation
{

    /**
     * @var SubmittedAllocationHeader $allocation
     */
    protected $allocation = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedAllocationHeader $allocation
     * @param string $submissionReference
     */
    public function __construct($allocation, $submissionReference)
    {
      $this->allocation = $allocation;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedAllocationHeader
     */
    public function getAllocation()
    {
      return $this->allocation;
    }

    /**
     * @param SubmittedAllocationHeader $allocation
     * @return \Eurostop\Stocks\SubmitAllocation
     */
    public function setAllocation($allocation)
    {
      $this->allocation = $allocation;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitAllocation
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
