<?php

namespace Eurostop\Stocks;

class StockWebServiceInterfacePlugin extends \SoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'WriteOnOffHeader' => 'Eurostop\\Stocks\\WriteOnOffHeader',
      'ArrayOfWriteOnOffDetail' => 'Eurostop\\Stocks\\ArrayOfWriteOnOffDetail',
      'WriteOnOffDetail' => 'Eurostop\\Stocks\\WriteOnOffDetail',
      'ArrayOfWriteOnOffHeader' => 'Eurostop\\Stocks\\ArrayOfWriteOnOffHeader',
      'ArrayOfSubmittedWriteOnOffLine' => 'Eurostop\\Stocks\\ArrayOfSubmittedWriteOnOffLine',
      'SubmittedWriteOnOffLine' => 'Eurostop\\Stocks\\SubmittedWriteOnOffLine',
      'ArrayOfSubmittedReplenishmentTarget' => 'Eurostop\\Stocks\\ArrayOfSubmittedReplenishmentTarget',
      'SubmittedReplenishmentTarget' => 'Eurostop\\Stocks\\SubmittedReplenishmentTarget',
      'ArrayOfSubmittedSkuReplenishmentCeiling' => 'Eurostop\\Stocks\\ArrayOfSubmittedSkuReplenishmentCeiling',
      'SubmittedSkuReplenishmentCeiling' => 'Eurostop\\Stocks\\SubmittedSkuReplenishmentCeiling',
      'AllocationHeader' => 'Eurostop\\Stocks\\AllocationHeader',
      'ArrayOfAllocationDetail' => 'Eurostop\\Stocks\\ArrayOfAllocationDetail',
      'AllocationDetail' => 'Eurostop\\Stocks\\AllocationDetail',
      'ArrayOfAllocationHeader' => 'Eurostop\\Stocks\\ArrayOfAllocationHeader',
      'SubmittedAllocationHeader' => 'Eurostop\\Stocks\\SubmittedAllocationHeader',
      'ArrayOfSubmittedAllocationItem' => 'Eurostop\\Stocks\\ArrayOfSubmittedAllocationItem',
      'SubmittedAllocationItem' => 'Eurostop\\Stocks\\SubmittedAllocationItem',
      'ArrayOfSubmittedAllocationHeader' => 'Eurostop\\Stocks\\ArrayOfSubmittedAllocationHeader',
      'SubmittedAllocationAction' => 'Eurostop\\Stocks\\SubmittedAllocationAction',
      'ArrayOfSubmittedAllocationAction' => 'Eurostop\\Stocks\\ArrayOfSubmittedAllocationAction',
      'AdviceNoteHeader' => 'Eurostop\\Stocks\\AdviceNoteHeader',
      'ArrayOfAdviceNoteDetail' => 'Eurostop\\Stocks\\ArrayOfAdviceNoteDetail',
      'AdviceNoteDetail' => 'Eurostop\\Stocks\\AdviceNoteDetail',
      'ArrayOfAdviceNoteHeader' => 'Eurostop\\Stocks\\ArrayOfAdviceNoteHeader',
      'Stock' => 'Eurostop\\Stocks\\Stock',
      'ArrayOfStock' => 'Eurostop\\Stocks\\ArrayOfStock',
      'ArrayOfSubmittedStockPosition' => 'Eurostop\\Stocks\\ArrayOfSubmittedStockPosition',
      'SubmittedStockPosition' => 'Eurostop\\Stocks\\SubmittedStockPosition',
      'StockForSku' => 'Eurostop\\Stocks\\StockForSku',
      'ArrayOfStockForSku' => 'Eurostop\\Stocks\\ArrayOfStockForSku',
      'ArrayOfSubmittedDeliveryLine' => 'Eurostop\\Stocks\\ArrayOfSubmittedDeliveryLine',
      'SubmittedDeliveryLine' => 'Eurostop\\Stocks\\SubmittedDeliveryLine',
      'DeliveryHeader' => 'Eurostop\\Stocks\\DeliveryHeader',
      'ArrayOfDeliveryDetail' => 'Eurostop\\Stocks\\ArrayOfDeliveryDetail',
      'DeliveryDetail' => 'Eurostop\\Stocks\\DeliveryDetail',
      'ArrayOfDeliveryHeader' => 'Eurostop\\Stocks\\ArrayOfDeliveryHeader',
      'TransferHeader' => 'Eurostop\\Stocks\\TransferHeader',
      'ArrayOfTransferDetail' => 'Eurostop\\Stocks\\ArrayOfTransferDetail',
      'TransferDetail' => 'Eurostop\\Stocks\\TransferDetail',
      'ArrayOfTransferHeader' => 'Eurostop\\Stocks\\ArrayOfTransferHeader',
      'ArrayOfSubmittedTransferLine' => 'Eurostop\\Stocks\\ArrayOfSubmittedTransferLine',
      'SubmittedTransferLine' => 'Eurostop\\Stocks\\SubmittedTransferLine',
      'SubmittedTransferHeader' => 'Eurostop\\Stocks\\SubmittedTransferHeader',
      'ArrayOfSubmittedTransferItem' => 'Eurostop\\Stocks\\ArrayOfSubmittedTransferItem',
      'SubmittedTransferItem' => 'Eurostop\\Stocks\\SubmittedTransferItem',
      'ArrayOfSubmittedTransferHeader' => 'Eurostop\\Stocks\\ArrayOfSubmittedTransferHeader',
      'SubmittedTransferAction' => 'Eurostop\\Stocks\\SubmittedTransferAction',
      'ArrayOfSubmittedTransferAction' => 'Eurostop\\Stocks\\ArrayOfSubmittedTransferAction',
      'PurchaseOrderHeader' => 'Eurostop\\Stocks\\PurchaseOrderHeader',
      'ArrayOfPurchaseOrderDetail' => 'Eurostop\\Stocks\\ArrayOfPurchaseOrderDetail',
      'PurchaseOrderDetail' => 'Eurostop\\Stocks\\PurchaseOrderDetail',
      'ArrayOfPurchaseOrderHeader' => 'Eurostop\\Stocks\\ArrayOfPurchaseOrderHeader',
      'ArrayOfSubmittedPurchaseOrderLine' => 'Eurostop\\Stocks\\ArrayOfSubmittedPurchaseOrderLine',
      'SubmittedPurchaseOrderLine' => 'Eurostop\\Stocks\\SubmittedPurchaseOrderLine',
      'SubmittedPurchaseOrderAction' => 'Eurostop\\Stocks\\SubmittedPurchaseOrderAction',
      'ArrayOfSubmittedPurchaseOrderAction' => 'Eurostop\\Stocks\\ArrayOfSubmittedPurchaseOrderAction',
      'DataRetrievalResultOfWriteOnOffHeaderF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfWriteOnOffHeaderF65MdnO4',
      'CodedRetrievedDataItemOfWriteOnOffHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\CodedRetrievedDataItemOfWriteOnOffHeaderDto6qbTdoQx',
      'RetrievedDataItemOfWriteOnOffHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfWriteOnOffHeaderDto6qbTdoQx',
      'RetrievedDataItemOfWriteOnOffDetailDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfWriteOnOffDetailDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedWriteOnOffLineDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedWriteOnOffLineDto6qbTdoQx',
      'DataSubmissionResult' => 'Eurostop\\Stocks\\DataSubmissionResult',
      'ArrayOfValidationError' => 'Eurostop\\Stocks\\ArrayOfValidationError',
      'ValidationError' => 'Eurostop\\Stocks\\ValidationError',
      'SubmittedDataItemOfSubmittedReplenishmentTargetDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedReplenishmentTargetDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedSkuReplenishmentCeilingDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedSkuReplenishmentCeilingDto6qbTdoQx',
      'ArrayOfDataProcessingResult' => 'Eurostop\\Stocks\\ArrayOfDataProcessingResult',
      'DataProcessingResult' => 'Eurostop\\Stocks\\DataProcessingResult',
      'ArrayOfDataProcessingStatus' => 'Eurostop\\Stocks\\ArrayOfDataProcessingStatus',
      'DataProcessingStatus' => 'Eurostop\\Stocks\\DataProcessingStatus',
      'DataRetrievalResultOfAllocationHeaderF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfAllocationHeaderF65MdnO4',
      'CodedRetrievedDataItemOfAllocationHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\CodedRetrievedDataItemOfAllocationHeaderDto6qbTdoQx',
      'RetrievedDataItemOfAllocationHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfAllocationHeaderDto6qbTdoQx',
      'RetrievedDataItemOfAllocationDetailDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfAllocationDetailDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedAllocationHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedAllocationHeaderDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedAllocationItemDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedAllocationItemDto6qbTdoQx',
      'SubmittedDataActionOfSubmittedAllocationActionDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataActionOfSubmittedAllocationActionDto6qbTdoQx',
      'DataRetrievalResultOfAdviceNoteHeaderF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfAdviceNoteHeaderF65MdnO4',
      'CodedRetrievedDataItemOfAdviceNoteHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\CodedRetrievedDataItemOfAdviceNoteHeaderDto6qbTdoQx',
      'RetrievedDataItemOfAdviceNoteHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfAdviceNoteHeaderDto6qbTdoQx',
      'RetrievedDataItemOfAdviceNoteDetailDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfAdviceNoteDetailDto6qbTdoQx',
      'DataRetrievalResultOfStockF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfStockF65MdnO4',
      'RetrievedDataItemOfStockPositionDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfStockPositionDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedStockPositionDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedStockPositionDto6qbTdoQx',
      'DataRetrievalResultOfStockForSkuF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfStockForSkuF65MdnO4',
      'RetrievedDataItemOfStockPositionForSkuDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfStockPositionForSkuDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedDeliveryLineDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedDeliveryLineDto6qbTdoQx',
      'DataRetrievalResultOfDeliveryHeaderF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfDeliveryHeaderF65MdnO4',
      'CodedRetrievedDataItemOfDeliveryHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\CodedRetrievedDataItemOfDeliveryHeaderDto6qbTdoQx',
      'RetrievedDataItemOfDeliveryHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfDeliveryHeaderDto6qbTdoQx',
      'RetrievedDataItemOfDeliveryDetailDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfDeliveryDetailDto6qbTdoQx',
      'DataRetrievalResultOfTransferHeaderF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfTransferHeaderF65MdnO4',
      'CodedRetrievedDataItemOfTransferHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\CodedRetrievedDataItemOfTransferHeaderDto6qbTdoQx',
      'RetrievedDataItemOfTransferHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfTransferHeaderDto6qbTdoQx',
      'RetrievedDataItemOfTransferDetailDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfTransferDetailDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedTransferLineDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedTransferLineDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedTransferHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedTransferHeaderDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedTransferItemDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedTransferItemDto6qbTdoQx',
      'SubmittedDataActionOfSubmittedTransferActionDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataActionOfSubmittedTransferActionDto6qbTdoQx',
      'DataRetrievalResultOfPurchaseOrderHeaderF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfPurchaseOrderHeaderF65MdnO4',
      'CodedRetrievedDataItemOfPurchaseOrderHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\CodedRetrievedDataItemOfPurchaseOrderHeaderDto6qbTdoQx',
      'RetrievedDataItemOfPurchaseOrderHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfPurchaseOrderHeaderDto6qbTdoQx',
      'RetrievedDataItemOfPurchaseOrderDetailDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfPurchaseOrderDetailDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedPurchaseOrderLineDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedPurchaseOrderLineDto6qbTdoQx',
      'SubmittedDataActionOfSubmittedPurchaseOrderActionDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataActionOfSubmittedPurchaseOrderActionDto6qbTdoQx',
      'ArrayOfstring' => 'Eurostop\\Stocks\\ArrayOfstring',
      'GetWriteOnOffByIdentifier' => 'Eurostop\\Stocks\\GetWriteOnOffByIdentifier',
      'GetWriteOnOffByIdentifierResponse' => 'Eurostop\\Stocks\\GetWriteOnOffByIdentifierResponse',
      'SubmitWriteOnOffs' => 'Eurostop\\Stocks\\SubmitWriteOnOffs',
      'SubmitWriteOnOffsResponse' => 'Eurostop\\Stocks\\SubmitWriteOnOffsResponse',
      'SubmitReplenishmentTargets' => 'Eurostop\\Stocks\\SubmitReplenishmentTargets',
      'SubmitReplenishmentTargetsResponse' => 'Eurostop\\Stocks\\SubmitReplenishmentTargetsResponse',
      'SubmitSkuReplenishmentCeilings' => 'Eurostop\\Stocks\\SubmitSkuReplenishmentCeilings',
      'SubmitSkuReplenishmentCeilingsResponse' => 'Eurostop\\Stocks\\SubmitSkuReplenishmentCeilingsResponse',
      'FlagDataProcessingToRetryByReference' => 'Eurostop\\Stocks\\FlagDataProcessingToRetryByReference',
      'FlagDataProcessingToRetryByReferenceResponse' => 'Eurostop\\Stocks\\FlagDataProcessingToRetryByReferenceResponse',
      'FlagDataProcessingToRetryByToken' => 'Eurostop\\Stocks\\FlagDataProcessingToRetryByToken',
      'FlagDataProcessingToRetryByTokenResponse' => 'Eurostop\\Stocks\\FlagDataProcessingToRetryByTokenResponse',
      'RunDataProcessingByReference' => 'Eurostop\\Stocks\\RunDataProcessingByReference',
      'RunDataProcessingByReferenceResponse' => 'Eurostop\\Stocks\\RunDataProcessingByReferenceResponse',
      'RunDataProcessingByToken' => 'Eurostop\\Stocks\\RunDataProcessingByToken',
      'RunDataProcessingByTokenResponse' => 'Eurostop\\Stocks\\RunDataProcessingByTokenResponse',
      'GetAllocationByIdentifier' => 'Eurostop\\Stocks\\GetAllocationByIdentifier',
      'GetAllocationByIdentifierResponse' => 'Eurostop\\Stocks\\GetAllocationByIdentifierResponse',
      'GetAllocationByIdentifierAndBranch' => 'Eurostop\\Stocks\\GetAllocationByIdentifierAndBranch',
      'GetAllocationByIdentifierAndBranchResponse' => 'Eurostop\\Stocks\\GetAllocationByIdentifierAndBranchResponse',
      'GetAllocationsByWarehouseAndDate' => 'Eurostop\\Stocks\\GetAllocationsByWarehouseAndDate',
      'GetAllocationsByWarehouseAndDateResponse' => 'Eurostop\\Stocks\\GetAllocationsByWarehouseAndDateResponse',
      'GetAllocationsByPurchaseOrder' => 'Eurostop\\Stocks\\GetAllocationsByPurchaseOrder',
      'GetAllocationsByPurchaseOrderResponse' => 'Eurostop\\Stocks\\GetAllocationsByPurchaseOrderResponse',
      'GetAllocationsByDelivery' => 'Eurostop\\Stocks\\GetAllocationsByDelivery',
      'GetAllocationsByDeliveryResponse' => 'Eurostop\\Stocks\\GetAllocationsByDeliveryResponse',
      'SubmitAllocation' => 'Eurostop\\Stocks\\SubmitAllocation',
      'SubmitAllocationResponse' => 'Eurostop\\Stocks\\SubmitAllocationResponse',
      'SubmitAllocations' => 'Eurostop\\Stocks\\SubmitAllocations',
      'SubmitAllocationsResponse' => 'Eurostop\\Stocks\\SubmitAllocationsResponse',
      'SubmitAllocationAction' => 'Eurostop\\Stocks\\SubmitAllocationAction',
      'SubmitAllocationActionResponse' => 'Eurostop\\Stocks\\SubmitAllocationActionResponse',
      'SubmitAllocationActions' => 'Eurostop\\Stocks\\SubmitAllocationActions',
      'SubmitAllocationActionsResponse' => 'Eurostop\\Stocks\\SubmitAllocationActionsResponse',
      'GetAdviceNoteByIdentifier' => 'Eurostop\\Stocks\\GetAdviceNoteByIdentifier',
      'GetAdviceNoteByIdentifierResponse' => 'Eurostop\\Stocks\\GetAdviceNoteByIdentifierResponse',
      'GetAdviceNotesByCreatedDate' => 'Eurostop\\Stocks\\GetAdviceNotesByCreatedDate',
      'GetAdviceNotesByCreatedDateResponse' => 'Eurostop\\Stocks\\GetAdviceNotesByCreatedDateResponse',
      'GetAdviceNotesByModifiedDate' => 'Eurostop\\Stocks\\GetAdviceNotesByModifiedDate',
      'GetAdviceNotesByModifiedDateResponse' => 'Eurostop\\Stocks\\GetAdviceNotesByModifiedDateResponse',
      'GetAdviceNotesByDespatchedDate' => 'Eurostop\\Stocks\\GetAdviceNotesByDespatchedDate',
      'GetAdviceNotesByDespatchedDateResponse' => 'Eurostop\\Stocks\\GetAdviceNotesByDespatchedDateResponse',
      'GetAdviceNotesByBookedInDate' => 'Eurostop\\Stocks\\GetAdviceNotesByBookedInDate',
      'GetAdviceNotesByBookedInDateResponse' => 'Eurostop\\Stocks\\GetAdviceNotesByBookedInDateResponse',
      'GetAdviceNotesByBranchCreatedDate' => 'Eurostop\\Stocks\\GetAdviceNotesByBranchCreatedDate',
      'GetAdviceNotesByBranchCreatedDateResponse' => 'Eurostop\\Stocks\\GetAdviceNotesByBranchCreatedDateResponse',
      'GetAdviceNotesByBranchModifiedDate' => 'Eurostop\\Stocks\\GetAdviceNotesByBranchModifiedDate',
      'GetAdviceNotesByBranchModifiedDateResponse' => 'Eurostop\\Stocks\\GetAdviceNotesByBranchModifiedDateResponse',
      'GetAdviceNotesByBranchDespatchedDate' => 'Eurostop\\Stocks\\GetAdviceNotesByBranchDespatchedDate',
      'GetAdviceNotesByBranchDespatchedDateResponse' => 'Eurostop\\Stocks\\GetAdviceNotesByBranchDespatchedDateResponse',
      'GetAdviceNotesByBranchBookedInDate' => 'Eurostop\\Stocks\\GetAdviceNotesByBranchBookedInDate',
      'GetAdviceNotesByBranchBookedInDateResponse' => 'Eurostop\\Stocks\\GetAdviceNotesByBranchBookedInDateResponse',
      'GetCurrentStockPositionByBranch' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranch',
      'GetCurrentStockPositionByBranchResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchResponse',
      'GetCurrentStockPositionByBranchAndSku' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndSku',
      'GetCurrentStockPositionByBranchAndSkuResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndSkuResponse',
      'GetCurrentStockPositionByBranchAndHierarchyNode' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndHierarchyNode',
      'GetCurrentStockPositionByBranchAndHierarchyNodeResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndHierarchyNodeResponse',
      'GetCurrentStockPositionByBranchAndProduct' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndProduct',
      'GetCurrentStockPositionByBranchAndProductResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndProductResponse',
      'GetCurrentStockPositionByBranchList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchList',
      'GetCurrentStockPositionByBranchListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListResponse',
      'GetCurrentStockPositionByBranchListAndSku' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndSku',
      'GetCurrentStockPositionByBranchListAndSkuResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndSkuResponse',
      'GetCurrentStockPositionByBranchListAndHierarchyNode' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndHierarchyNode',
      'GetCurrentStockPositionByBranchListAndHierarchyNodeResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndHierarchyNodeResponse',
      'GetCurrentStockPositionByBranchListAndProduct' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndProduct',
      'GetCurrentStockPositionByBranchListAndProductResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndProductResponse',
      'GetCurrentStockPositionBySku' => 'Eurostop\\Stocks\\GetCurrentStockPositionBySku',
      'GetCurrentStockPositionBySkuResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionBySkuResponse',
      'GetCurrentStockPositionByHierarchyNode' => 'Eurostop\\Stocks\\GetCurrentStockPositionByHierarchyNode',
      'GetCurrentStockPositionByHierarchyNodeResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByHierarchyNodeResponse',
      'GetCurrentStockPositionByProduct' => 'Eurostop\\Stocks\\GetCurrentStockPositionByProduct',
      'GetCurrentStockPositionByProductResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByProductResponse',
      'GetCurrentStockPositionByProductAnalysisValue' => 'Eurostop\\Stocks\\GetCurrentStockPositionByProductAnalysisValue',
      'GetCurrentStockPositionByProductAnalysisValueResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByProductAnalysisValueResponse',
      'GetCurrentStockPositionByProductAnalysisValueList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByProductAnalysisValueList',
      'GetCurrentStockPositionByProductAnalysisValueListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByProductAnalysisValueListResponse',
      'GetCurrentStockPositionByBranchGroupAndProductAnalysisValue' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndProductAnalysisValue',
      'GetCurrentStockPositionByBranchGroupAndProductAnalysisValueResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndProductAnalysisValueResponse',
      'GetCurrentStockPositionByBranchGroupAndProductAnalysisValueList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndProductAnalysisValueList',
      'GetCurrentStockPositionByBranchGroupAndProductAnalysisValueListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndProductAnalysisValueListResponse',
      'GetCurrentStockPositionByBranchGroup' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroup',
      'GetCurrentStockPositionByBranchGroupResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupResponse',
      'GetCurrentStockPositionByBranchGroupAndProduct' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndProduct',
      'GetCurrentStockPositionByBranchGroupAndProductResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndProductResponse',
      'GetCurrentStockPositionByBranchGroupAndSku' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndSku',
      'GetCurrentStockPositionByBranchGroupAndSkuResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndSkuResponse',
      'GetCurrentStockPositionByBranchGroupAndProductList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndProductList',
      'GetCurrentStockPositionByBranchGroupAndProductListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndProductListResponse',
      'GetCurrentStockPositionByBranchAndProductList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndProductList',
      'GetCurrentStockPositionByBranchAndProductListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndProductListResponse',
      'GetCurrentStockPositionByBranchListAndProductList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndProductList',
      'GetCurrentStockPositionByBranchListAndProductListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndProductListResponse',
      'GetCurrentStockPositionByBranchGroupAndSkuList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndSkuList',
      'GetCurrentStockPositionByBranchGroupAndSkuListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndSkuListResponse',
      'GetCurrentStockPositionByBranchAndSkuList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndSkuList',
      'GetCurrentStockPositionByBranchAndSkuListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndSkuListResponse',
      'GetCurrentStockPositionByBranchListAndSkuList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndSkuList',
      'GetCurrentStockPositionByBranchListAndSkuListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndSkuListResponse',
      'SubmitNewStockPositions' => 'Eurostop\\Stocks\\SubmitNewStockPositions',
      'SubmitNewStockPositionsResponse' => 'Eurostop\\Stocks\\SubmitNewStockPositionsResponse',
      'GetCurrentSkuStockByBranch' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranch',
      'GetCurrentSkuStockByBranchResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchResponse',
      'GetCurrentSkuStockByBranchAndSku' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndSku',
      'GetCurrentSkuStockByBranchAndSkuResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndSkuResponse',
      'GetCurrentSkuStockByBranchAndHierarchyNode' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndHierarchyNode',
      'GetCurrentSkuStockByBranchAndHierarchyNodeResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndHierarchyNodeResponse',
      'GetCurrentSkuStockByBranchAndProduct' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndProduct',
      'GetCurrentSkuStockByBranchAndProductResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndProductResponse',
      'GetCurrentSkuStockByBranchList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchList',
      'GetCurrentSkuStockByBranchListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListResponse',
      'GetCurrentSkuStockByBranchListAndSku' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndSku',
      'GetCurrentSkuStockByBranchListAndSkuResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndSkuResponse',
      'GetCurrentSkuStockByBranchListAndHierarchyNode' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndHierarchyNode',
      'GetCurrentSkuStockByBranchListAndHierarchyNodeResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndHierarchyNodeResponse',
      'GetCurrentSkuStockByBranchListAndProduct' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndProduct',
      'GetCurrentSkuStockByBranchListAndProductResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndProductResponse',
      'GetCurrentSkuStockBySku' => 'Eurostop\\Stocks\\GetCurrentSkuStockBySku',
      'GetCurrentSkuStockBySkuResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockBySkuResponse',
      'GetCurrentSkuStockByHierarchyNode' => 'Eurostop\\Stocks\\GetCurrentSkuStockByHierarchyNode',
      'GetCurrentSkuStockByHierarchyNodeResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByHierarchyNodeResponse',
      'GetCurrentSkuStockByProduct' => 'Eurostop\\Stocks\\GetCurrentSkuStockByProduct',
      'GetCurrentSkuStockByProductResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByProductResponse',
      'GetCurrentSkuStockByProductAnalysisValue' => 'Eurostop\\Stocks\\GetCurrentSkuStockByProductAnalysisValue',
      'GetCurrentSkuStockByProductAnalysisValueResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByProductAnalysisValueResponse',
      'GetCurrentSkuStockByProductAnalysisValueList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByProductAnalysisValueList',
      'GetCurrentSkuStockByProductAnalysisValueListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByProductAnalysisValueListResponse',
      'GetCurrentSkuStockByBranchGroupAndProductAnalysisValue' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndProductAnalysisValue',
      'GetCurrentSkuStockByBranchGroupAndProductAnalysisValueResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndProductAnalysisValueResponse',
      'GetCurrentSkuStockByBranchGroupAndProductAnalysisValueList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndProductAnalysisValueList',
      'GetCurrentSkuStockByBranchGroupAndProductAnalysisValueListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndProductAnalysisValueListResponse',
      'GetCurrentSkuStockByBranchGroup' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroup',
      'GetCurrentSkuStockByBranchGroupResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupResponse',
      'GetCurrentSkuStockByBranchGroupAndProduct' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndProduct',
      'GetCurrentSkuStockByBranchGroupAndProductResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndProductResponse',
      'GetCurrentSkuStockByBranchGroupAndSku' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndSku',
      'GetCurrentSkuStockByBranchGroupAndSkuResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndSkuResponse',
      'GetCurrentSkuStockByBranchGroupAndProductList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndProductList',
      'GetCurrentSkuStockByBranchGroupAndProductListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndProductListResponse',
      'GetCurrentSkuStockByBranchAndProductList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndProductList',
      'GetCurrentSkuStockByBranchAndProductListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndProductListResponse',
      'GetCurrentSkuStockByBranchListAndProductList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndProductList',
      'GetCurrentSkuStockByBranchListAndProductListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndProductListResponse',
      'GetCurrentSkuStockByBranchGroupAndSkuList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndSkuList',
      'GetCurrentSkuStockByBranchGroupAndSkuListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndSkuListResponse',
      'GetCurrentSkuStockByBranchAndSkuList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndSkuList',
      'GetCurrentSkuStockByBranchAndSkuListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndSkuListResponse',
      'GetCurrentSkuStockByBranchListAndSkuList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndSkuList',
      'GetCurrentSkuStockByBranchListAndSkuListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndSkuListResponse',
      'SubmitDeliveries' => 'Eurostop\\Stocks\\SubmitDeliveries',
      'SubmitDeliveriesResponse' => 'Eurostop\\Stocks\\SubmitDeliveriesResponse',
      'GetDeliveriesByWarehouse' => 'Eurostop\\Stocks\\GetDeliveriesByWarehouse',
      'GetDeliveriesByWarehouseResponse' => 'Eurostop\\Stocks\\GetDeliveriesByWarehouseResponse',
      'GetDeliveriesByWarehouseAndDate' => 'Eurostop\\Stocks\\GetDeliveriesByWarehouseAndDate',
      'GetDeliveriesByWarehouseAndDateResponse' => 'Eurostop\\Stocks\\GetDeliveriesByWarehouseAndDateResponse',
      'GetDeliveriesByDates' => 'Eurostop\\Stocks\\GetDeliveriesByDates',
      'GetDeliveriesByDatesResponse' => 'Eurostop\\Stocks\\GetDeliveriesByDatesResponse',
      'GetDeliveryByIdentifier' => 'Eurostop\\Stocks\\GetDeliveryByIdentifier',
      'GetDeliveryByIdentifierResponse' => 'Eurostop\\Stocks\\GetDeliveryByIdentifierResponse',
      'GetDeliveriesByPurchaseOrder' => 'Eurostop\\Stocks\\GetDeliveriesByPurchaseOrder',
      'GetDeliveriesByPurchaseOrderResponse' => 'Eurostop\\Stocks\\GetDeliveriesByPurchaseOrderResponse',
      'GetConsolidatedTransfersByBranchTransferDate' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBranchTransferDate',
      'GetConsolidatedTransfersByBranchTransferDateResponse' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBranchTransferDateResponse',
      'GetConsolidatedTransfersByBranchConfirmedDate' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBranchConfirmedDate',
      'GetConsolidatedTransfersByBranchConfirmedDateResponse' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBranchConfirmedDateResponse',
      'GetConsolidatedTransfersByBranchBookedInDate' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBranchBookedInDate',
      'GetConsolidatedTransfersByBranchBookedInDateResponse' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBranchBookedInDateResponse',
      'GetConsolidatedTransfersByTransferDate' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByTransferDate',
      'GetConsolidatedTransfersByTransferDateResponse' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByTransferDateResponse',
      'GetConsolidatedTransfersByConfirmedDate' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByConfirmedDate',
      'GetConsolidatedTransfersByConfirmedDateResponse' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByConfirmedDateResponse',
      'GetConsolidatedTransfersByBookedInDate' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBookedInDate',
      'GetConsolidatedTransfersByBookedInDateResponse' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBookedInDateResponse',
      'GetConsolidatedTransferByIdentifier' => 'Eurostop\\Stocks\\GetConsolidatedTransferByIdentifier',
      'GetConsolidatedTransferByIdentifierResponse' => 'Eurostop\\Stocks\\GetConsolidatedTransferByIdentifierResponse',
      'GetInOutTransfersByBranchTransferDate' => 'Eurostop\\Stocks\\GetInOutTransfersByBranchTransferDate',
      'GetInOutTransfersByBranchTransferDateResponse' => 'Eurostop\\Stocks\\GetInOutTransfersByBranchTransferDateResponse',
      'GetInOutTransfersByBranchConfirmedDate' => 'Eurostop\\Stocks\\GetInOutTransfersByBranchConfirmedDate',
      'GetInOutTransfersByBranchConfirmedDateResponse' => 'Eurostop\\Stocks\\GetInOutTransfersByBranchConfirmedDateResponse',
      'GetInOutTransfersByBranchBookedInDate' => 'Eurostop\\Stocks\\GetInOutTransfersByBranchBookedInDate',
      'GetInOutTransfersByBranchBookedInDateResponse' => 'Eurostop\\Stocks\\GetInOutTransfersByBranchBookedInDateResponse',
      'GetInOutTransfersByTransferDate' => 'Eurostop\\Stocks\\GetInOutTransfersByTransferDate',
      'GetInOutTransfersByTransferDateResponse' => 'Eurostop\\Stocks\\GetInOutTransfersByTransferDateResponse',
      'GetInOutTransfersByConfirmedDate' => 'Eurostop\\Stocks\\GetInOutTransfersByConfirmedDate',
      'GetInOutTransfersByConfirmedDateResponse' => 'Eurostop\\Stocks\\GetInOutTransfersByConfirmedDateResponse',
      'GetInOutTransfersByBookedInDate' => 'Eurostop\\Stocks\\GetInOutTransfersByBookedInDate',
      'GetInOutTransfersByBookedInDateResponse' => 'Eurostop\\Stocks\\GetInOutTransfersByBookedInDateResponse',
      'GetInOutTransferByIdentifier' => 'Eurostop\\Stocks\\GetInOutTransferByIdentifier',
      'GetInOutTransferByIdentifierResponse' => 'Eurostop\\Stocks\\GetInOutTransferByIdentifierResponse',
      'SubmitTransfers' => 'Eurostop\\Stocks\\SubmitTransfers',
      'SubmitTransfersResponse' => 'Eurostop\\Stocks\\SubmitTransfersResponse',
      'SubmitTransferBatch' => 'Eurostop\\Stocks\\SubmitTransferBatch',
      'SubmitTransferBatchResponse' => 'Eurostop\\Stocks\\SubmitTransferBatchResponse',
      'SubmitTransferBatches' => 'Eurostop\\Stocks\\SubmitTransferBatches',
      'SubmitTransferBatchesResponse' => 'Eurostop\\Stocks\\SubmitTransferBatchesResponse',
      'SubmitTransferAction' => 'Eurostop\\Stocks\\SubmitTransferAction',
      'SubmitTransferActionResponse' => 'Eurostop\\Stocks\\SubmitTransferActionResponse',
      'SubmitTransferActions' => 'Eurostop\\Stocks\\SubmitTransferActions',
      'SubmitTransferActionsResponse' => 'Eurostop\\Stocks\\SubmitTransferActionsResponse',
      'GetPurchaseOrdersByIdentifier' => 'Eurostop\\Stocks\\GetPurchaseOrdersByIdentifier',
      'GetPurchaseOrdersByIdentifierResponse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByIdentifierResponse',
      'GetPurchaseOrdersByDate' => 'Eurostop\\Stocks\\GetPurchaseOrdersByDate',
      'GetPurchaseOrdersByDateResponse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByDateResponse',
      'GetPurchaseOrdersByWarehouse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByWarehouse',
      'GetPurchaseOrdersByWarehouseResponse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByWarehouseResponse',
      'GetPurchaseOrdersByWarehouseAndDate' => 'Eurostop\\Stocks\\GetPurchaseOrdersByWarehouseAndDate',
      'GetPurchaseOrdersByWarehouseAndDateResponse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByWarehouseAndDateResponse',
      'GetPurchaseOrdersByConfirmedDate' => 'Eurostop\\Stocks\\GetPurchaseOrdersByConfirmedDate',
      'GetPurchaseOrdersByConfirmedDateResponse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByConfirmedDateResponse',
      'GetPurchaseOrdersByWarehouseAndConfirmedDate' => 'Eurostop\\Stocks\\GetPurchaseOrdersByWarehouseAndConfirmedDate',
      'GetPurchaseOrdersByWarehouseAndConfirmedDateResponse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByWarehouseAndConfirmedDateResponse',
      'SubmitPurchaseOrders' => 'Eurostop\\Stocks\\SubmitPurchaseOrders',
      'SubmitPurchaseOrdersResponse' => 'Eurostop\\Stocks\\SubmitPurchaseOrdersResponse',
      'SubmitPurchaseOrderAction' => 'Eurostop\\Stocks\\SubmitPurchaseOrderAction',
      'SubmitPurchaseOrderActionResponse' => 'Eurostop\\Stocks\\SubmitPurchaseOrderActionResponse',
      'SubmitPurchaseOrderActions' => 'Eurostop\\Stocks\\SubmitPurchaseOrderActions',
      'SubmitPurchaseOrderActionsResponse' => 'Eurostop\\Stocks\\SubmitPurchaseOrderActionsResponse',
      'GetWriteOnOffsByBranchDate' => 'Eurostop\\Stocks\\GetWriteOnOffsByBranchDate',
      'GetWriteOnOffsByBranchDateResponse' => 'Eurostop\\Stocks\\GetWriteOnOffsByBranchDateResponse',
      'GetWriteOnOffsByDate' => 'Eurostop\\Stocks\\GetWriteOnOffsByDate',
      'GetWriteOnOffsByDateResponse' => 'Eurostop\\Stocks\\GetWriteOnOffsByDateResponse',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://database-test.eurostop.jdsportscanada.com:9120/e-interface/stocks?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param GetWriteOnOffByIdentifier $parameters
     * @return GetWriteOnOffByIdentifierResponse
     */
    public function GetWriteOnOffByIdentifier(GetWriteOnOffByIdentifier $parameters)
    {
      return $this->__soapCall('GetWriteOnOffByIdentifier', array($parameters));
    }

    /**
     * @param SubmitWriteOnOffs $parameters
     * @return SubmitWriteOnOffsResponse
     */
    public function SubmitWriteOnOffs(SubmitWriteOnOffs $parameters)
    {
      return $this->__soapCall('SubmitWriteOnOffs', array($parameters));
    }

    /**
     * @param SubmitReplenishmentTargets $parameters
     * @return SubmitReplenishmentTargetsResponse
     */
    public function SubmitReplenishmentTargets(SubmitReplenishmentTargets $parameters)
    {
      return $this->__soapCall('SubmitReplenishmentTargets', array($parameters));
    }

    /**
     * @param SubmitSkuReplenishmentCeilings $parameters
     * @return SubmitSkuReplenishmentCeilingsResponse
     */
    public function SubmitSkuReplenishmentCeilings(SubmitSkuReplenishmentCeilings $parameters)
    {
      return $this->__soapCall('SubmitSkuReplenishmentCeilings', array($parameters));
    }

    /**
     * @param FlagDataProcessingToRetryByReference $parameters
     * @return FlagDataProcessingToRetryByReferenceResponse
     */
    public function FlagDataProcessingToRetryByReference(FlagDataProcessingToRetryByReference $parameters)
    {
      return $this->__soapCall('FlagDataProcessingToRetryByReference', array($parameters));
    }

    /**
     * @param FlagDataProcessingToRetryByToken $parameters
     * @return FlagDataProcessingToRetryByTokenResponse
     */
    public function FlagDataProcessingToRetryByToken(FlagDataProcessingToRetryByToken $parameters)
    {
      return $this->__soapCall('FlagDataProcessingToRetryByToken', array($parameters));
    }

    /**
     * @param RunDataProcessingByReference $parameters
     * @return RunDataProcessingByReferenceResponse
     */
    public function RunDataProcessingByReference(RunDataProcessingByReference $parameters)
    {
      return $this->__soapCall('RunDataProcessingByReference', array($parameters));
    }

    /**
     * @param RunDataProcessingByToken $parameters
     * @return RunDataProcessingByTokenResponse
     */
    public function RunDataProcessingByToken(RunDataProcessingByToken $parameters)
    {
      return $this->__soapCall('RunDataProcessingByToken', array($parameters));
    }

    /**
     * @param GetAllocationByIdentifier $parameters
     * @return GetAllocationByIdentifierResponse
     */
    public function GetAllocationByIdentifier(GetAllocationByIdentifier $parameters)
    {
      return $this->__soapCall('GetAllocationByIdentifier', array($parameters));
    }

    /**
     * @param GetAllocationByIdentifierAndBranch $parameters
     * @return GetAllocationByIdentifierAndBranchResponse
     */
    public function GetAllocationByIdentifierAndBranch(GetAllocationByIdentifierAndBranch $parameters)
    {
      return $this->__soapCall('GetAllocationByIdentifierAndBranch', array($parameters));
    }

    /**
     * @param GetAllocationsByWarehouseAndDate $parameters
     * @return GetAllocationsByWarehouseAndDateResponse
     */
    public function GetAllocationsByWarehouseAndDate(GetAllocationsByWarehouseAndDate $parameters)
    {
      return $this->__soapCall('GetAllocationsByWarehouseAndDate', array($parameters));
    }

    /**
     * @param GetAllocationsByPurchaseOrder $parameters
     * @return GetAllocationsByPurchaseOrderResponse
     */
    public function GetAllocationsByPurchaseOrder(GetAllocationsByPurchaseOrder $parameters)
    {
      return $this->__soapCall('GetAllocationsByPurchaseOrder', array($parameters));
    }

    /**
     * @param GetAllocationsByDelivery $parameters
     * @return GetAllocationsByDeliveryResponse
     */
    public function GetAllocationsByDelivery(GetAllocationsByDelivery $parameters)
    {
      return $this->__soapCall('GetAllocationsByDelivery', array($parameters));
    }

    /**
     * @param SubmitAllocation $parameters
     * @return SubmitAllocationResponse
     */
    public function SubmitAllocation(SubmitAllocation $parameters)
    {
      return $this->__soapCall('SubmitAllocation', array($parameters));
    }

    /**
     * @param SubmitAllocations $parameters
     * @return SubmitAllocationsResponse
     */
    public function SubmitAllocations(SubmitAllocations $parameters)
    {
      return $this->__soapCall('SubmitAllocations', array($parameters));
    }

    /**
     * @param SubmitAllocationAction $parameters
     * @return SubmitAllocationActionResponse
     */
    public function SubmitAllocationAction(SubmitAllocationAction $parameters)
    {
      return $this->__soapCall('SubmitAllocationAction', array($parameters));
    }

    /**
     * @param SubmitAllocationActions $parameters
     * @return SubmitAllocationActionsResponse
     */
    public function SubmitAllocationActions(SubmitAllocationActions $parameters)
    {
      return $this->__soapCall('SubmitAllocationActions', array($parameters));
    }

    /**
     * @param GetAdviceNoteByIdentifier $parameters
     * @return GetAdviceNoteByIdentifierResponse
     */
    public function GetAdviceNoteByIdentifier(GetAdviceNoteByIdentifier $parameters)
    {
      return $this->__soapCall('GetAdviceNoteByIdentifier', array($parameters));
    }

    /**
     * @param GetAdviceNotesByCreatedDate $parameters
     * @return GetAdviceNotesByCreatedDateResponse
     */
    public function GetAdviceNotesByCreatedDate(GetAdviceNotesByCreatedDate $parameters)
    {
      return $this->__soapCall('GetAdviceNotesByCreatedDate', array($parameters));
    }

    /**
     * @param GetAdviceNotesByModifiedDate $parameters
     * @return GetAdviceNotesByModifiedDateResponse
     */
    public function GetAdviceNotesByModifiedDate(GetAdviceNotesByModifiedDate $parameters)
    {
      return $this->__soapCall('GetAdviceNotesByModifiedDate', array($parameters));
    }

    /**
     * @param GetAdviceNotesByDespatchedDate $parameters
     * @return GetAdviceNotesByDespatchedDateResponse
     */
    public function GetAdviceNotesByDespatchedDate(GetAdviceNotesByDespatchedDate $parameters)
    {
      return $this->__soapCall('GetAdviceNotesByDespatchedDate', array($parameters));
    }

    /**
     * @param GetAdviceNotesByBookedInDate $parameters
     * @return GetAdviceNotesByBookedInDateResponse
     */
    public function GetAdviceNotesByBookedInDate(GetAdviceNotesByBookedInDate $parameters)
    {
      return $this->__soapCall('GetAdviceNotesByBookedInDate', array($parameters));
    }

    /**
     * @param GetAdviceNotesByBranchCreatedDate $parameters
     * @return GetAdviceNotesByBranchCreatedDateResponse
     */
    public function GetAdviceNotesByBranchCreatedDate(GetAdviceNotesByBranchCreatedDate $parameters)
    {
      return $this->__soapCall('GetAdviceNotesByBranchCreatedDate', array($parameters));
    }

    /**
     * @param GetAdviceNotesByBranchModifiedDate $parameters
     * @return GetAdviceNotesByBranchModifiedDateResponse
     */
    public function GetAdviceNotesByBranchModifiedDate(GetAdviceNotesByBranchModifiedDate $parameters)
    {
      return $this->__soapCall('GetAdviceNotesByBranchModifiedDate', array($parameters));
    }

    /**
     * @param GetAdviceNotesByBranchDespatchedDate $parameters
     * @return GetAdviceNotesByBranchDespatchedDateResponse
     */
    public function GetAdviceNotesByBranchDespatchedDate(GetAdviceNotesByBranchDespatchedDate $parameters)
    {
      return $this->__soapCall('GetAdviceNotesByBranchDespatchedDate', array($parameters));
    }

    /**
     * @param GetAdviceNotesByBranchBookedInDate $parameters
     * @return GetAdviceNotesByBranchBookedInDateResponse
     */
    public function GetAdviceNotesByBranchBookedInDate(GetAdviceNotesByBranchBookedInDate $parameters)
    {
      return $this->__soapCall('GetAdviceNotesByBranchBookedInDate', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranch $parameters
     * @return GetCurrentStockPositionByBranchResponse
     */
    public function GetCurrentStockPositionByBranch(GetCurrentStockPositionByBranch $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranch', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchAndSku $parameters
     * @return GetCurrentStockPositionByBranchAndSkuResponse
     */
    public function GetCurrentStockPositionByBranchAndSku(GetCurrentStockPositionByBranchAndSku $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchAndSku', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchAndHierarchyNode $parameters
     * @return GetCurrentStockPositionByBranchAndHierarchyNodeResponse
     */
    public function GetCurrentStockPositionByBranchAndHierarchyNode(GetCurrentStockPositionByBranchAndHierarchyNode $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchAndHierarchyNode', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchAndProduct $parameters
     * @return GetCurrentStockPositionByBranchAndProductResponse
     */
    public function GetCurrentStockPositionByBranchAndProduct(GetCurrentStockPositionByBranchAndProduct $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchAndProduct', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchList $parameters
     * @return GetCurrentStockPositionByBranchListResponse
     */
    public function GetCurrentStockPositionByBranchList(GetCurrentStockPositionByBranchList $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchList', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchListAndSku $parameters
     * @return GetCurrentStockPositionByBranchListAndSkuResponse
     */
    public function GetCurrentStockPositionByBranchListAndSku(GetCurrentStockPositionByBranchListAndSku $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchListAndSku', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchListAndHierarchyNode $parameters
     * @return GetCurrentStockPositionByBranchListAndHierarchyNodeResponse
     */
    public function GetCurrentStockPositionByBranchListAndHierarchyNode(GetCurrentStockPositionByBranchListAndHierarchyNode $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchListAndHierarchyNode', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchListAndProduct $parameters
     * @return GetCurrentStockPositionByBranchListAndProductResponse
     */
    public function GetCurrentStockPositionByBranchListAndProduct(GetCurrentStockPositionByBranchListAndProduct $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchListAndProduct', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionBySku $parameters
     * @return GetCurrentStockPositionBySkuResponse
     */
    public function GetCurrentStockPositionBySku(GetCurrentStockPositionBySku $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionBySku', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByHierarchyNode $parameters
     * @return GetCurrentStockPositionByHierarchyNodeResponse
     */
    public function GetCurrentStockPositionByHierarchyNode(GetCurrentStockPositionByHierarchyNode $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByHierarchyNode', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByProduct $parameters
     * @return GetCurrentStockPositionByProductResponse
     */
    public function GetCurrentStockPositionByProduct(GetCurrentStockPositionByProduct $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByProduct', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByProductAnalysisValue $parameters
     * @return GetCurrentStockPositionByProductAnalysisValueResponse
     */
    public function GetCurrentStockPositionByProductAnalysisValue(GetCurrentStockPositionByProductAnalysisValue $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByProductAnalysisValue', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByProductAnalysisValueList $parameters
     * @return GetCurrentStockPositionByProductAnalysisValueListResponse
     */
    public function GetCurrentStockPositionByProductAnalysisValueList(GetCurrentStockPositionByProductAnalysisValueList $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByProductAnalysisValueList', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchGroupAndProductAnalysisValue $parameters
     * @return GetCurrentStockPositionByBranchGroupAndProductAnalysisValueResponse
     */
    public function GetCurrentStockPositionByBranchGroupAndProductAnalysisValue(GetCurrentStockPositionByBranchGroupAndProductAnalysisValue $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchGroupAndProductAnalysisValue', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchGroupAndProductAnalysisValueList $parameters
     * @return GetCurrentStockPositionByBranchGroupAndProductAnalysisValueListResponse
     */
    public function GetCurrentStockPositionByBranchGroupAndProductAnalysisValueList(GetCurrentStockPositionByBranchGroupAndProductAnalysisValueList $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchGroupAndProductAnalysisValueList', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchGroup $parameters
     * @return GetCurrentStockPositionByBranchGroupResponse
     */
    public function GetCurrentStockPositionByBranchGroup(GetCurrentStockPositionByBranchGroup $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchGroup', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchGroupAndProduct $parameters
     * @return GetCurrentStockPositionByBranchGroupAndProductResponse
     */
    public function GetCurrentStockPositionByBranchGroupAndProduct(GetCurrentStockPositionByBranchGroupAndProduct $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchGroupAndProduct', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchGroupAndSku $parameters
     * @return GetCurrentStockPositionByBranchGroupAndSkuResponse
     */
    public function GetCurrentStockPositionByBranchGroupAndSku(GetCurrentStockPositionByBranchGroupAndSku $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchGroupAndSku', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchGroupAndProductList $parameters
     * @return GetCurrentStockPositionByBranchGroupAndProductListResponse
     */
    public function GetCurrentStockPositionByBranchGroupAndProductList(GetCurrentStockPositionByBranchGroupAndProductList $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchGroupAndProductList', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchAndProductList $parameters
     * @return GetCurrentStockPositionByBranchAndProductListResponse
     */
    public function GetCurrentStockPositionByBranchAndProductList(GetCurrentStockPositionByBranchAndProductList $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchAndProductList', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchListAndProductList $parameters
     * @return GetCurrentStockPositionByBranchListAndProductListResponse
     */
    public function GetCurrentStockPositionByBranchListAndProductList(GetCurrentStockPositionByBranchListAndProductList $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchListAndProductList', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchGroupAndSkuList $parameters
     * @return GetCurrentStockPositionByBranchGroupAndSkuListResponse
     */
    public function GetCurrentStockPositionByBranchGroupAndSkuList(GetCurrentStockPositionByBranchGroupAndSkuList $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchGroupAndSkuList', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchAndSkuList $parameters
     * @return GetCurrentStockPositionByBranchAndSkuListResponse
     */
    public function GetCurrentStockPositionByBranchAndSkuList(GetCurrentStockPositionByBranchAndSkuList $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchAndSkuList', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchListAndSkuList $parameters
     * @return GetCurrentStockPositionByBranchListAndSkuListResponse
     */
    public function GetCurrentStockPositionByBranchListAndSkuList(GetCurrentStockPositionByBranchListAndSkuList $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchListAndSkuList', array($parameters));
    }

    /**
     * @param SubmitNewStockPositions $parameters
     * @return SubmitNewStockPositionsResponse
     */
    public function SubmitNewStockPositions(SubmitNewStockPositions $parameters)
    {
      return $this->__soapCall('SubmitNewStockPositions', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranch $parameters
     * @return GetCurrentSkuStockByBranchResponse
     */
    public function GetCurrentSkuStockByBranch(GetCurrentSkuStockByBranch $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranch', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchAndSku $parameters
     * @return GetCurrentSkuStockByBranchAndSkuResponse
     */
    public function GetCurrentSkuStockByBranchAndSku(GetCurrentSkuStockByBranchAndSku $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchAndSku', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchAndHierarchyNode $parameters
     * @return GetCurrentSkuStockByBranchAndHierarchyNodeResponse
     */
    public function GetCurrentSkuStockByBranchAndHierarchyNode(GetCurrentSkuStockByBranchAndHierarchyNode $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchAndHierarchyNode', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchAndProduct $parameters
     * @return GetCurrentSkuStockByBranchAndProductResponse
     */
    public function GetCurrentSkuStockByBranchAndProduct(GetCurrentSkuStockByBranchAndProduct $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchAndProduct', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchList $parameters
     * @return GetCurrentSkuStockByBranchListResponse
     */
    public function GetCurrentSkuStockByBranchList(GetCurrentSkuStockByBranchList $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchList', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchListAndSku $parameters
     * @return GetCurrentSkuStockByBranchListAndSkuResponse
     */
    public function GetCurrentSkuStockByBranchListAndSku(GetCurrentSkuStockByBranchListAndSku $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchListAndSku', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchListAndHierarchyNode $parameters
     * @return GetCurrentSkuStockByBranchListAndHierarchyNodeResponse
     */
    public function GetCurrentSkuStockByBranchListAndHierarchyNode(GetCurrentSkuStockByBranchListAndHierarchyNode $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchListAndHierarchyNode', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchListAndProduct $parameters
     * @return GetCurrentSkuStockByBranchListAndProductResponse
     */
    public function GetCurrentSkuStockByBranchListAndProduct(GetCurrentSkuStockByBranchListAndProduct $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchListAndProduct', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockBySku $parameters
     * @return GetCurrentSkuStockBySkuResponse
     */
    public function GetCurrentSkuStockBySku(GetCurrentSkuStockBySku $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockBySku', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByHierarchyNode $parameters
     * @return GetCurrentSkuStockByHierarchyNodeResponse
     */
    public function GetCurrentSkuStockByHierarchyNode(GetCurrentSkuStockByHierarchyNode $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByHierarchyNode', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByProduct $parameters
     * @return GetCurrentSkuStockByProductResponse
     */
    public function GetCurrentSkuStockByProduct(GetCurrentSkuStockByProduct $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByProduct', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByProductAnalysisValue $parameters
     * @return GetCurrentSkuStockByProductAnalysisValueResponse
     */
    public function GetCurrentSkuStockByProductAnalysisValue(GetCurrentSkuStockByProductAnalysisValue $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByProductAnalysisValue', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByProductAnalysisValueList $parameters
     * @return GetCurrentSkuStockByProductAnalysisValueListResponse
     */
    public function GetCurrentSkuStockByProductAnalysisValueList(GetCurrentSkuStockByProductAnalysisValueList $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByProductAnalysisValueList', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchGroupAndProductAnalysisValue $parameters
     * @return GetCurrentSkuStockByBranchGroupAndProductAnalysisValueResponse
     */
    public function GetCurrentSkuStockByBranchGroupAndProductAnalysisValue(GetCurrentSkuStockByBranchGroupAndProductAnalysisValue $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchGroupAndProductAnalysisValue', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchGroupAndProductAnalysisValueList $parameters
     * @return GetCurrentSkuStockByBranchGroupAndProductAnalysisValueListResponse
     */
    public function GetCurrentSkuStockByBranchGroupAndProductAnalysisValueList(GetCurrentSkuStockByBranchGroupAndProductAnalysisValueList $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchGroupAndProductAnalysisValueList', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchGroup $parameters
     * @return GetCurrentSkuStockByBranchGroupResponse
     */
    public function GetCurrentSkuStockByBranchGroup(GetCurrentSkuStockByBranchGroup $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchGroup', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchGroupAndProduct $parameters
     * @return GetCurrentSkuStockByBranchGroupAndProductResponse
     */
    public function GetCurrentSkuStockByBranchGroupAndProduct(GetCurrentSkuStockByBranchGroupAndProduct $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchGroupAndProduct', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchGroupAndSku $parameters
     * @return GetCurrentSkuStockByBranchGroupAndSkuResponse
     */
    public function GetCurrentSkuStockByBranchGroupAndSku(GetCurrentSkuStockByBranchGroupAndSku $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchGroupAndSku', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchGroupAndProductList $parameters
     * @return GetCurrentSkuStockByBranchGroupAndProductListResponse
     */
    public function GetCurrentSkuStockByBranchGroupAndProductList(GetCurrentSkuStockByBranchGroupAndProductList $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchGroupAndProductList', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchAndProductList $parameters
     * @return GetCurrentSkuStockByBranchAndProductListResponse
     */
    public function GetCurrentSkuStockByBranchAndProductList(GetCurrentSkuStockByBranchAndProductList $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchAndProductList', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchListAndProductList $parameters
     * @return GetCurrentSkuStockByBranchListAndProductListResponse
     */
    public function GetCurrentSkuStockByBranchListAndProductList(GetCurrentSkuStockByBranchListAndProductList $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchListAndProductList', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchGroupAndSkuList $parameters
     * @return GetCurrentSkuStockByBranchGroupAndSkuListResponse
     */
    public function GetCurrentSkuStockByBranchGroupAndSkuList(GetCurrentSkuStockByBranchGroupAndSkuList $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchGroupAndSkuList', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchAndSkuList $parameters
     * @return GetCurrentSkuStockByBranchAndSkuListResponse
     */
    public function GetCurrentSkuStockByBranchAndSkuList(GetCurrentSkuStockByBranchAndSkuList $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchAndSkuList', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchListAndSkuList $parameters
     * @return GetCurrentSkuStockByBranchListAndSkuListResponse
     */
    public function GetCurrentSkuStockByBranchListAndSkuList(GetCurrentSkuStockByBranchListAndSkuList $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchListAndSkuList', array($parameters));
    }

    /**
     * @param SubmitDeliveries $parameters
     * @return SubmitDeliveriesResponse
     */
    public function SubmitDeliveries(SubmitDeliveries $parameters)
    {
      return $this->__soapCall('SubmitDeliveries', array($parameters));
    }

    /**
     * @param GetDeliveriesByWarehouse $parameters
     * @return GetDeliveriesByWarehouseResponse
     */
    public function GetDeliveriesByWarehouse(GetDeliveriesByWarehouse $parameters)
    {
      return $this->__soapCall('GetDeliveriesByWarehouse', array($parameters));
    }

    /**
     * @param GetDeliveriesByWarehouseAndDate $parameters
     * @return GetDeliveriesByWarehouseAndDateResponse
     */
    public function GetDeliveriesByWarehouseAndDate(GetDeliveriesByWarehouseAndDate $parameters)
    {
      return $this->__soapCall('GetDeliveriesByWarehouseAndDate', array($parameters));
    }

    /**
     * @param GetDeliveriesByDates $parameters
     * @return GetDeliveriesByDatesResponse
     */
    public function GetDeliveriesByDates(GetDeliveriesByDates $parameters)
    {
      return $this->__soapCall('GetDeliveriesByDates', array($parameters));
    }

    /**
     * @param GetDeliveryByIdentifier $parameters
     * @return GetDeliveryByIdentifierResponse
     */
    public function GetDeliveryByIdentifier(GetDeliveryByIdentifier $parameters)
    {
      return $this->__soapCall('GetDeliveryByIdentifier', array($parameters));
    }

    /**
     * @param GetDeliveriesByPurchaseOrder $parameters
     * @return GetDeliveriesByPurchaseOrderResponse
     */
    public function GetDeliveriesByPurchaseOrder(GetDeliveriesByPurchaseOrder $parameters)
    {
      return $this->__soapCall('GetDeliveriesByPurchaseOrder', array($parameters));
    }

    /**
     * @param GetConsolidatedTransfersByBranchTransferDate $parameters
     * @return GetConsolidatedTransfersByBranchTransferDateResponse
     */
    public function GetConsolidatedTransfersByBranchTransferDate(GetConsolidatedTransfersByBranchTransferDate $parameters)
    {
      return $this->__soapCall('GetConsolidatedTransfersByBranchTransferDate', array($parameters));
    }

    /**
     * @param GetConsolidatedTransfersByBranchConfirmedDate $parameters
     * @return GetConsolidatedTransfersByBranchConfirmedDateResponse
     */
    public function GetConsolidatedTransfersByBranchConfirmedDate(GetConsolidatedTransfersByBranchConfirmedDate $parameters)
    {
      return $this->__soapCall('GetConsolidatedTransfersByBranchConfirmedDate', array($parameters));
    }

    /**
     * @param GetConsolidatedTransfersByBranchBookedInDate $parameters
     * @return GetConsolidatedTransfersByBranchBookedInDateResponse
     */
    public function GetConsolidatedTransfersByBranchBookedInDate(GetConsolidatedTransfersByBranchBookedInDate $parameters)
    {
      return $this->__soapCall('GetConsolidatedTransfersByBranchBookedInDate', array($parameters));
    }

    /**
     * @param GetConsolidatedTransfersByTransferDate $parameters
     * @return GetConsolidatedTransfersByTransferDateResponse
     */
    public function GetConsolidatedTransfersByTransferDate(GetConsolidatedTransfersByTransferDate $parameters)
    {
      return $this->__soapCall('GetConsolidatedTransfersByTransferDate', array($parameters));
    }

    /**
     * @param GetConsolidatedTransfersByConfirmedDate $parameters
     * @return GetConsolidatedTransfersByConfirmedDateResponse
     */
    public function GetConsolidatedTransfersByConfirmedDate(GetConsolidatedTransfersByConfirmedDate $parameters)
    {
      return $this->__soapCall('GetConsolidatedTransfersByConfirmedDate', array($parameters));
    }

    /**
     * @param GetConsolidatedTransfersByBookedInDate $parameters
     * @return GetConsolidatedTransfersByBookedInDateResponse
     */
    public function GetConsolidatedTransfersByBookedInDate(GetConsolidatedTransfersByBookedInDate $parameters)
    {
      return $this->__soapCall('GetConsolidatedTransfersByBookedInDate', array($parameters));
    }

    /**
     * @param GetConsolidatedTransferByIdentifier $parameters
     * @return GetConsolidatedTransferByIdentifierResponse
     */
    public function GetConsolidatedTransferByIdentifier(GetConsolidatedTransferByIdentifier $parameters)
    {
      return $this->__soapCall('GetConsolidatedTransferByIdentifier', array($parameters));
    }

    /**
     * @param GetInOutTransfersByBranchTransferDate $parameters
     * @return GetInOutTransfersByBranchTransferDateResponse
     */
    public function GetInOutTransfersByBranchTransferDate(GetInOutTransfersByBranchTransferDate $parameters)
    {
      return $this->__soapCall('GetInOutTransfersByBranchTransferDate', array($parameters));
    }

    /**
     * @param GetInOutTransfersByBranchConfirmedDate $parameters
     * @return GetInOutTransfersByBranchConfirmedDateResponse
     */
    public function GetInOutTransfersByBranchConfirmedDate(GetInOutTransfersByBranchConfirmedDate $parameters)
    {
      return $this->__soapCall('GetInOutTransfersByBranchConfirmedDate', array($parameters));
    }

    /**
     * @param GetInOutTransfersByBranchBookedInDate $parameters
     * @return GetInOutTransfersByBranchBookedInDateResponse
     */
    public function GetInOutTransfersByBranchBookedInDate(GetInOutTransfersByBranchBookedInDate $parameters)
    {
      return $this->__soapCall('GetInOutTransfersByBranchBookedInDate', array($parameters));
    }

    /**
     * @param GetInOutTransfersByTransferDate $parameters
     * @return GetInOutTransfersByTransferDateResponse
     */
    public function GetInOutTransfersByTransferDate(GetInOutTransfersByTransferDate $parameters)
    {
      return $this->__soapCall('GetInOutTransfersByTransferDate', array($parameters));
    }

    /**
     * @param GetInOutTransfersByConfirmedDate $parameters
     * @return GetInOutTransfersByConfirmedDateResponse
     */
    public function GetInOutTransfersByConfirmedDate(GetInOutTransfersByConfirmedDate $parameters)
    {
      return $this->__soapCall('GetInOutTransfersByConfirmedDate', array($parameters));
    }

    /**
     * @param GetInOutTransfersByBookedInDate $parameters
     * @return GetInOutTransfersByBookedInDateResponse
     */
    public function GetInOutTransfersByBookedInDate(GetInOutTransfersByBookedInDate $parameters)
    {
      return $this->__soapCall('GetInOutTransfersByBookedInDate', array($parameters));
    }

    /**
     * @param GetInOutTransferByIdentifier $parameters
     * @return GetInOutTransferByIdentifierResponse
     */
    public function GetInOutTransferByIdentifier(GetInOutTransferByIdentifier $parameters)
    {
      return $this->__soapCall('GetInOutTransferByIdentifier', array($parameters));
    }

    /**
     * @param SubmitTransfers $parameters
     * @return SubmitTransfersResponse
     */
    public function SubmitTransfers(SubmitTransfers $parameters)
    {
      return $this->__soapCall('SubmitTransfers', array($parameters));
    }

    /**
     * @param SubmitTransferBatch $parameters
     * @return SubmitTransferBatchResponse
     */
    public function SubmitTransferBatch(SubmitTransferBatch $parameters)
    {
      return $this->__soapCall('SubmitTransferBatch', array($parameters));
    }

    /**
     * @param SubmitTransferBatches $parameters
     * @return SubmitTransferBatchesResponse
     */
    public function SubmitTransferBatches(SubmitTransferBatches $parameters)
    {
      return $this->__soapCall('SubmitTransferBatches', array($parameters));
    }

    /**
     * @param SubmitTransferAction $parameters
     * @return SubmitTransferActionResponse
     */
    public function SubmitTransferAction(SubmitTransferAction $parameters)
    {
      return $this->__soapCall('SubmitTransferAction', array($parameters));
    }

    /**
     * @param SubmitTransferActions $parameters
     * @return SubmitTransferActionsResponse
     */
    public function SubmitTransferActions(SubmitTransferActions $parameters)
    {
      return $this->__soapCall('SubmitTransferActions', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByIdentifier $parameters
     * @return GetPurchaseOrdersByIdentifierResponse
     */
    public function GetPurchaseOrdersByIdentifier(GetPurchaseOrdersByIdentifier $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByIdentifier', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByDate $parameters
     * @return GetPurchaseOrdersByDateResponse
     */
    public function GetPurchaseOrdersByDate(GetPurchaseOrdersByDate $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByDate', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByWarehouse $parameters
     * @return GetPurchaseOrdersByWarehouseResponse
     */
    public function GetPurchaseOrdersByWarehouse(GetPurchaseOrdersByWarehouse $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByWarehouse', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByWarehouseAndDate $parameters
     * @return GetPurchaseOrdersByWarehouseAndDateResponse
     */
    public function GetPurchaseOrdersByWarehouseAndDate(GetPurchaseOrdersByWarehouseAndDate $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByWarehouseAndDate', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByConfirmedDate $parameters
     * @return GetPurchaseOrdersByConfirmedDateResponse
     */
    public function GetPurchaseOrdersByConfirmedDate(GetPurchaseOrdersByConfirmedDate $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByConfirmedDate', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByWarehouseAndConfirmedDate $parameters
     * @return GetPurchaseOrdersByWarehouseAndConfirmedDateResponse
     */
    public function GetPurchaseOrdersByWarehouseAndConfirmedDate(GetPurchaseOrdersByWarehouseAndConfirmedDate $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByWarehouseAndConfirmedDate', array($parameters));
    }

    /**
     * @param SubmitPurchaseOrders $parameters
     * @return SubmitPurchaseOrdersResponse
     */
    public function SubmitPurchaseOrders(SubmitPurchaseOrders $parameters)
    {
      return $this->__soapCall('SubmitPurchaseOrders', array($parameters));
    }

    /**
     * @param SubmitPurchaseOrderAction $parameters
     * @return SubmitPurchaseOrderActionResponse
     */
    public function SubmitPurchaseOrderAction(SubmitPurchaseOrderAction $parameters)
    {
      return $this->__soapCall('SubmitPurchaseOrderAction', array($parameters));
    }

    /**
     * @param SubmitPurchaseOrderActions $parameters
     * @return SubmitPurchaseOrderActionsResponse
     */
    public function SubmitPurchaseOrderActions(SubmitPurchaseOrderActions $parameters)
    {
      return $this->__soapCall('SubmitPurchaseOrderActions', array($parameters));
    }

    /**
     * @param GetWriteOnOffsByBranchDate $parameters
     * @return GetWriteOnOffsByBranchDateResponse
     */
    public function GetWriteOnOffsByBranchDate(GetWriteOnOffsByBranchDate $parameters)
    {
      return $this->__soapCall('GetWriteOnOffsByBranchDate', array($parameters));
    }

    /**
     * @param GetWriteOnOffsByDate $parameters
     * @return GetWriteOnOffsByDateResponse
     */
    public function GetWriteOnOffsByDate(GetWriteOnOffsByDate $parameters)
    {
      return $this->__soapCall('GetWriteOnOffsByDate', array($parameters));
    }

}
