<?php

namespace Eurostop\Stocks;

class GetInOutTransfersByTransferDate
{

    /**
     * @var \DateTime $createdFromDate
     */
    protected $createdFromDate = null;

    /**
     * @var \DateTime $createdToDate
     */
    protected $createdToDate = null;

    /**
     * @var boolean $includeTransfersOut
     */
    protected $includeTransfersOut = null;

    /**
     * @var boolean $includeTransfersIn
     */
    protected $includeTransfersIn = null;

    /**
     * @var boolean $includeUnConfirmed
     */
    protected $includeUnConfirmed = null;

    /**
     * @param \DateTime $createdFromDate
     * @param \DateTime $createdToDate
     * @param boolean $includeTransfersOut
     * @param boolean $includeTransfersIn
     * @param boolean $includeUnConfirmed
     */
    public function __construct(\DateTime $createdFromDate, \DateTime $createdToDate, $includeTransfersOut, $includeTransfersIn, $includeUnConfirmed)
    {
      $this->createdFromDate = $createdFromDate->format(\DateTime::ATOM);
      $this->createdToDate = $createdToDate->format(\DateTime::ATOM);
      $this->includeTransfersOut = $includeTransfersOut;
      $this->includeTransfersIn = $includeTransfersIn;
      $this->includeUnConfirmed = $includeUnConfirmed;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedFromDate()
    {
      if ($this->createdFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->createdFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $createdFromDate
     * @return \Eurostop\Stocks\GetInOutTransfersByTransferDate
     */
    public function setCreatedFromDate(\DateTime $createdFromDate)
    {
      $this->createdFromDate = $createdFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedToDate()
    {
      if ($this->createdToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->createdToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $createdToDate
     * @return \Eurostop\Stocks\GetInOutTransfersByTransferDate
     */
    public function setCreatedToDate(\DateTime $createdToDate)
    {
      $this->createdToDate = $createdToDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeTransfersOut()
    {
      return $this->includeTransfersOut;
    }

    /**
     * @param boolean $includeTransfersOut
     * @return \Eurostop\Stocks\GetInOutTransfersByTransferDate
     */
    public function setIncludeTransfersOut($includeTransfersOut)
    {
      $this->includeTransfersOut = $includeTransfersOut;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeTransfersIn()
    {
      return $this->includeTransfersIn;
    }

    /**
     * @param boolean $includeTransfersIn
     * @return \Eurostop\Stocks\GetInOutTransfersByTransferDate
     */
    public function setIncludeTransfersIn($includeTransfersIn)
    {
      $this->includeTransfersIn = $includeTransfersIn;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeUnConfirmed()
    {
      return $this->includeUnConfirmed;
    }

    /**
     * @param boolean $includeUnConfirmed
     * @return \Eurostop\Stocks\GetInOutTransfersByTransferDate
     */
    public function setIncludeUnConfirmed($includeUnConfirmed)
    {
      $this->includeUnConfirmed = $includeUnConfirmed;
      return $this;
    }

}
