<?php

namespace Eurostop\Stocks;

class GetInOutTransfersByConfirmedDate
{

    /**
     * @var \DateTime $confirmedFromDate
     */
    protected $confirmedFromDate = null;

    /**
     * @var \DateTime $confirmedToDate
     */
    protected $confirmedToDate = null;

    /**
     * @var boolean $includeTransfersOut
     */
    protected $includeTransfersOut = null;

    /**
     * @var boolean $includeTransfersIn
     */
    protected $includeTransfersIn = null;

    /**
     * @param \DateTime $confirmedFromDate
     * @param \DateTime $confirmedToDate
     * @param boolean $includeTransfersOut
     * @param boolean $includeTransfersIn
     */
    public function __construct(\DateTime $confirmedFromDate, \DateTime $confirmedToDate, $includeTransfersOut, $includeTransfersIn)
    {
      $this->confirmedFromDate = $confirmedFromDate->format(\DateTime::ATOM);
      $this->confirmedToDate = $confirmedToDate->format(\DateTime::ATOM);
      $this->includeTransfersOut = $includeTransfersOut;
      $this->includeTransfersIn = $includeTransfersIn;
    }

    /**
     * @return \DateTime
     */
    public function getConfirmedFromDate()
    {
      if ($this->confirmedFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->confirmedFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $confirmedFromDate
     * @return \Eurostop\Stocks\GetInOutTransfersByConfirmedDate
     */
    public function setConfirmedFromDate(\DateTime $confirmedFromDate)
    {
      $this->confirmedFromDate = $confirmedFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getConfirmedToDate()
    {
      if ($this->confirmedToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->confirmedToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $confirmedToDate
     * @return \Eurostop\Stocks\GetInOutTransfersByConfirmedDate
     */
    public function setConfirmedToDate(\DateTime $confirmedToDate)
    {
      $this->confirmedToDate = $confirmedToDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeTransfersOut()
    {
      return $this->includeTransfersOut;
    }

    /**
     * @param boolean $includeTransfersOut
     * @return \Eurostop\Stocks\GetInOutTransfersByConfirmedDate
     */
    public function setIncludeTransfersOut($includeTransfersOut)
    {
      $this->includeTransfersOut = $includeTransfersOut;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeTransfersIn()
    {
      return $this->includeTransfersIn;
    }

    /**
     * @param boolean $includeTransfersIn
     * @return \Eurostop\Stocks\GetInOutTransfersByConfirmedDate
     */
    public function setIncludeTransfersIn($includeTransfersIn)
    {
      $this->includeTransfersIn = $includeTransfersIn;
      return $this;
    }

}
