<?php

namespace Eurostop\Stocks;

class GetCurrentStockPositionByBranchListAndSkuList
{

    /**
     * @var ArrayOfstring $branchIdentifiers
     */
    protected $branchIdentifiers = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var ArrayOfstring $skuIdentifiers
     */
    protected $skuIdentifiers = null;

    /**
     * @var SkuIdentifierType $skuIdentifierType
     */
    protected $skuIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @var boolean $nonZeroOnly
     */
    protected $nonZeroOnly = null;

    /**
     * @param ArrayOfstring $branchIdentifiers
     * @param BranchIdentifierType $branchIdentifierType
     * @param ArrayOfstring $skuIdentifiers
     * @param SkuIdentifierType $skuIdentifierType
     * @param \DateTime $modifiedSinceDate
     * @param boolean $nonZeroOnly
     */
    public function __construct($branchIdentifiers, $branchIdentifierType, $skuIdentifiers, $skuIdentifierType, \DateTime $modifiedSinceDate, $nonZeroOnly)
    {
      $this->branchIdentifiers = $branchIdentifiers;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->skuIdentifiers = $skuIdentifiers;
      $this->skuIdentifierType = $skuIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      $this->nonZeroOnly = $nonZeroOnly;
    }

    /**
     * @return ArrayOfstring
     */
    public function getBranchIdentifiers()
    {
      return $this->branchIdentifiers;
    }

    /**
     * @param ArrayOfstring $branchIdentifiers
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchListAndSkuList
     */
    public function setBranchIdentifiers($branchIdentifiers)
    {
      $this->branchIdentifiers = $branchIdentifiers;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchListAndSkuList
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getSkuIdentifiers()
    {
      return $this->skuIdentifiers;
    }

    /**
     * @param ArrayOfstring $skuIdentifiers
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchListAndSkuList
     */
    public function setSkuIdentifiers($skuIdentifiers)
    {
      $this->skuIdentifiers = $skuIdentifiers;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->skuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $skuIdentifierType
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchListAndSkuList
     */
    public function setSkuIdentifierType($skuIdentifierType)
    {
      $this->skuIdentifierType = $skuIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchListAndSkuList
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getNonZeroOnly()
    {
      return $this->nonZeroOnly;
    }

    /**
     * @param boolean $nonZeroOnly
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchListAndSkuList
     */
    public function setNonZeroOnly($nonZeroOnly)
    {
      $this->nonZeroOnly = $nonZeroOnly;
      return $this;
    }

}
