<?php

namespace Eurostop\Stocks;

class GetCurrentStockPositionByBranchList
{

    /**
     * @var ArrayOfstring $branchIdentifiers
     */
    protected $branchIdentifiers = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @var boolean $nonZeroOnly
     */
    protected $nonZeroOnly = null;

    /**
     * @var int $maxPositions
     */
    protected $maxPositions = null;

    /**
     * @param ArrayOfstring $branchIdentifiers
     * @param BranchIdentifierType $branchIdentifierType
     * @param \DateTime $modifiedSinceDate
     * @param boolean $nonZeroOnly
     * @param int $maxPositions
     */
    public function __construct($branchIdentifiers, $branchIdentifierType, \DateTime $modifiedSinceDate, $nonZeroOnly, $maxPositions)
    {
      $this->branchIdentifiers = $branchIdentifiers;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      $this->nonZeroOnly = $nonZeroOnly;
      $this->maxPositions = $maxPositions;
    }

    /**
     * @return ArrayOfstring
     */
    public function getBranchIdentifiers()
    {
      return $this->branchIdentifiers;
    }

    /**
     * @param ArrayOfstring $branchIdentifiers
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchList
     */
    public function setBranchIdentifiers($branchIdentifiers)
    {
      $this->branchIdentifiers = $branchIdentifiers;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchList
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchList
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getNonZeroOnly()
    {
      return $this->nonZeroOnly;
    }

    /**
     * @param boolean $nonZeroOnly
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchList
     */
    public function setNonZeroOnly($nonZeroOnly)
    {
      $this->nonZeroOnly = $nonZeroOnly;
      return $this;
    }

    /**
     * @return int
     */
    public function getMaxPositions()
    {
      return $this->maxPositions;
    }

    /**
     * @param int $maxPositions
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchList
     */
    public function setMaxPositions($maxPositions)
    {
      $this->maxPositions = $maxPositions;
      return $this;
    }

}
