<?php

namespace Eurostop\Stocks;

class GetCurrentStockPositionByBranchGroupAndProductAnalysisValue
{

    /**
     * @var string $branchGroupIdentifier
     */
    protected $branchGroupIdentifier = null;

    /**
     * @var BranchGroupIdentifierType $branchGroupIdentifierType
     */
    protected $branchGroupIdentifierType = null;

    /**
     * @var string $analysisTypeIdentifier
     */
    protected $analysisTypeIdentifier = null;

    /**
     * @var AnalysisTypeIdentifierType $analysisTypeIdentifierType
     */
    protected $analysisTypeIdentifierType = null;

    /**
     * @var string $analysisValueIdentifier
     */
    protected $analysisValueIdentifier = null;

    /**
     * @var AnalysisValueIdentifierType $analysisValueIdentifierType
     */
    protected $analysisValueIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @var boolean $nonZeroOnly
     */
    protected $nonZeroOnly = null;

    /**
     * @param string $branchGroupIdentifier
     * @param BranchGroupIdentifierType $branchGroupIdentifierType
     * @param string $analysisTypeIdentifier
     * @param AnalysisTypeIdentifierType $analysisTypeIdentifierType
     * @param string $analysisValueIdentifier
     * @param AnalysisValueIdentifierType $analysisValueIdentifierType
     * @param \DateTime $modifiedSinceDate
     * @param boolean $nonZeroOnly
     */
    public function __construct($branchGroupIdentifier, $branchGroupIdentifierType, $analysisTypeIdentifier, $analysisTypeIdentifierType, $analysisValueIdentifier, $analysisValueIdentifierType, \DateTime $modifiedSinceDate, $nonZeroOnly)
    {
      $this->branchGroupIdentifier = $branchGroupIdentifier;
      $this->branchGroupIdentifierType = $branchGroupIdentifierType;
      $this->analysisTypeIdentifier = $analysisTypeIdentifier;
      $this->analysisTypeIdentifierType = $analysisTypeIdentifierType;
      $this->analysisValueIdentifier = $analysisValueIdentifier;
      $this->analysisValueIdentifierType = $analysisValueIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      $this->nonZeroOnly = $nonZeroOnly;
    }

    /**
     * @return string
     */
    public function getBranchGroupIdentifier()
    {
      return $this->branchGroupIdentifier;
    }

    /**
     * @param string $branchGroupIdentifier
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndProductAnalysisValue
     */
    public function setBranchGroupIdentifier($branchGroupIdentifier)
    {
      $this->branchGroupIdentifier = $branchGroupIdentifier;
      return $this;
    }

    /**
     * @return BranchGroupIdentifierType
     */
    public function getBranchGroupIdentifierType()
    {
      return $this->branchGroupIdentifierType;
    }

    /**
     * @param BranchGroupIdentifierType $branchGroupIdentifierType
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndProductAnalysisValue
     */
    public function setBranchGroupIdentifierType($branchGroupIdentifierType)
    {
      $this->branchGroupIdentifierType = $branchGroupIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getAnalysisTypeIdentifier()
    {
      return $this->analysisTypeIdentifier;
    }

    /**
     * @param string $analysisTypeIdentifier
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndProductAnalysisValue
     */
    public function setAnalysisTypeIdentifier($analysisTypeIdentifier)
    {
      $this->analysisTypeIdentifier = $analysisTypeIdentifier;
      return $this;
    }

    /**
     * @return AnalysisTypeIdentifierType
     */
    public function getAnalysisTypeIdentifierType()
    {
      return $this->analysisTypeIdentifierType;
    }

    /**
     * @param AnalysisTypeIdentifierType $analysisTypeIdentifierType
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndProductAnalysisValue
     */
    public function setAnalysisTypeIdentifierType($analysisTypeIdentifierType)
    {
      $this->analysisTypeIdentifierType = $analysisTypeIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getAnalysisValueIdentifier()
    {
      return $this->analysisValueIdentifier;
    }

    /**
     * @param string $analysisValueIdentifier
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndProductAnalysisValue
     */
    public function setAnalysisValueIdentifier($analysisValueIdentifier)
    {
      $this->analysisValueIdentifier = $analysisValueIdentifier;
      return $this;
    }

    /**
     * @return AnalysisValueIdentifierType
     */
    public function getAnalysisValueIdentifierType()
    {
      return $this->analysisValueIdentifierType;
    }

    /**
     * @param AnalysisValueIdentifierType $analysisValueIdentifierType
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndProductAnalysisValue
     */
    public function setAnalysisValueIdentifierType($analysisValueIdentifierType)
    {
      $this->analysisValueIdentifierType = $analysisValueIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndProductAnalysisValue
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getNonZeroOnly()
    {
      return $this->nonZeroOnly;
    }

    /**
     * @param boolean $nonZeroOnly
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndProductAnalysisValue
     */
    public function setNonZeroOnly($nonZeroOnly)
    {
      $this->nonZeroOnly = $nonZeroOnly;
      return $this;
    }

}
