<?php

namespace Eurostop\Stocks;

class GetCurrentSkuStockByProductAnalysisValue
{

    /**
     * @var string $analysisTypeIdentifier
     */
    protected $analysisTypeIdentifier = null;

    /**
     * @var AnalysisTypeIdentifierType $analysisTypeIdentifierType
     */
    protected $analysisTypeIdentifierType = null;

    /**
     * @var string $analysisValueIdentifier
     */
    protected $analysisValueIdentifier = null;

    /**
     * @var AnalysisValueIdentifierType $analysisValueIdentifierType
     */
    protected $analysisValueIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @var boolean $nonZeroOnly
     */
    protected $nonZeroOnly = null;

    /**
     * @param string $analysisTypeIdentifier
     * @param AnalysisTypeIdentifierType $analysisTypeIdentifierType
     * @param string $analysisValueIdentifier
     * @param AnalysisValueIdentifierType $analysisValueIdentifierType
     * @param \DateTime $modifiedSinceDate
     * @param boolean $nonZeroOnly
     */
    public function __construct($analysisTypeIdentifier, $analysisTypeIdentifierType, $analysisValueIdentifier, $analysisValueIdentifierType, \DateTime $modifiedSinceDate, $nonZeroOnly)
    {
      $this->analysisTypeIdentifier = $analysisTypeIdentifier;
      $this->analysisTypeIdentifierType = $analysisTypeIdentifierType;
      $this->analysisValueIdentifier = $analysisValueIdentifier;
      $this->analysisValueIdentifierType = $analysisValueIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      $this->nonZeroOnly = $nonZeroOnly;
    }

    /**
     * @return string
     */
    public function getAnalysisTypeIdentifier()
    {
      return $this->analysisTypeIdentifier;
    }

    /**
     * @param string $analysisTypeIdentifier
     * @return \Eurostop\Stocks\GetCurrentSkuStockByProductAnalysisValue
     */
    public function setAnalysisTypeIdentifier($analysisTypeIdentifier)
    {
      $this->analysisTypeIdentifier = $analysisTypeIdentifier;
      return $this;
    }

    /**
     * @return AnalysisTypeIdentifierType
     */
    public function getAnalysisTypeIdentifierType()
    {
      return $this->analysisTypeIdentifierType;
    }

    /**
     * @param AnalysisTypeIdentifierType $analysisTypeIdentifierType
     * @return \Eurostop\Stocks\GetCurrentSkuStockByProductAnalysisValue
     */
    public function setAnalysisTypeIdentifierType($analysisTypeIdentifierType)
    {
      $this->analysisTypeIdentifierType = $analysisTypeIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getAnalysisValueIdentifier()
    {
      return $this->analysisValueIdentifier;
    }

    /**
     * @param string $analysisValueIdentifier
     * @return \Eurostop\Stocks\GetCurrentSkuStockByProductAnalysisValue
     */
    public function setAnalysisValueIdentifier($analysisValueIdentifier)
    {
      $this->analysisValueIdentifier = $analysisValueIdentifier;
      return $this;
    }

    /**
     * @return AnalysisValueIdentifierType
     */
    public function getAnalysisValueIdentifierType()
    {
      return $this->analysisValueIdentifierType;
    }

    /**
     * @param AnalysisValueIdentifierType $analysisValueIdentifierType
     * @return \Eurostop\Stocks\GetCurrentSkuStockByProductAnalysisValue
     */
    public function setAnalysisValueIdentifierType($analysisValueIdentifierType)
    {
      $this->analysisValueIdentifierType = $analysisValueIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Stocks\GetCurrentSkuStockByProductAnalysisValue
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getNonZeroOnly()
    {
      return $this->nonZeroOnly;
    }

    /**
     * @param boolean $nonZeroOnly
     * @return \Eurostop\Stocks\GetCurrentSkuStockByProductAnalysisValue
     */
    public function setNonZeroOnly($nonZeroOnly)
    {
      $this->nonZeroOnly = $nonZeroOnly;
      return $this;
    }

}
