<?php

namespace Eurostop\Stocks;

class GetCurrentSkuStockByBranchListAndProduct
{

    /**
     * @var ArrayOfstring $branchIdentifiers
     */
    protected $branchIdentifiers = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var string $productIdentifier
     */
    protected $productIdentifier = null;

    /**
     * @var ProductIdentifierType $productIdentifierType
     */
    protected $productIdentifierType = null;

    /**
     * @param ArrayOfstring $branchIdentifiers
     * @param BranchIdentifierType $branchIdentifierType
     * @param string $productIdentifier
     * @param ProductIdentifierType $productIdentifierType
     */
    public function __construct($branchIdentifiers, $branchIdentifierType, $productIdentifier, $productIdentifierType)
    {
      $this->branchIdentifiers = $branchIdentifiers;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->productIdentifier = $productIdentifier;
      $this->productIdentifierType = $productIdentifierType;
    }

    /**
     * @return ArrayOfstring
     */
    public function getBranchIdentifiers()
    {
      return $this->branchIdentifiers;
    }

    /**
     * @param ArrayOfstring $branchIdentifiers
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchListAndProduct
     */
    public function setBranchIdentifiers($branchIdentifiers)
    {
      $this->branchIdentifiers = $branchIdentifiers;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchListAndProduct
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getProductIdentifier()
    {
      return $this->productIdentifier;
    }

    /**
     * @param string $productIdentifier
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchListAndProduct
     */
    public function setProductIdentifier($productIdentifier)
    {
      $this->productIdentifier = $productIdentifier;
      return $this;
    }

    /**
     * @return ProductIdentifierType
     */
    public function getProductIdentifierType()
    {
      return $this->productIdentifierType;
    }

    /**
     * @param ProductIdentifierType $productIdentifierType
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchListAndProduct
     */
    public function setProductIdentifierType($productIdentifierType)
    {
      $this->productIdentifierType = $productIdentifierType;
      return $this;
    }

}
