<?php

namespace Eurostop\Stocks;

class GetCurrentSkuStockByBranch
{

    /**
     * @var string $branchIdentifier
     */
    protected $branchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @var boolean $nonZeroOnly
     */
    protected $nonZeroOnly = null;

    /**
     * @var int $maxPositions
     */
    protected $maxPositions = null;

    /**
     * @param string $branchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param \DateTime $modifiedSinceDate
     * @param boolean $nonZeroOnly
     * @param int $maxPositions
     */
    public function __construct($branchIdentifier, $branchIdentifierType, \DateTime $modifiedSinceDate, $nonZeroOnly, $maxPositions)
    {
      $this->branchIdentifier = $branchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      $this->nonZeroOnly = $nonZeroOnly;
      $this->maxPositions = $maxPositions;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->branchIdentifier;
    }

    /**
     * @param string $branchIdentifier
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranch
     */
    public function setBranchIdentifier($branchIdentifier)
    {
      $this->branchIdentifier = $branchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranch
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranch
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getNonZeroOnly()
    {
      return $this->nonZeroOnly;
    }

    /**
     * @param boolean $nonZeroOnly
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranch
     */
    public function setNonZeroOnly($nonZeroOnly)
    {
      $this->nonZeroOnly = $nonZeroOnly;
      return $this;
    }

    /**
     * @return int
     */
    public function getMaxPositions()
    {
      return $this->maxPositions;
    }

    /**
     * @param int $maxPositions
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranch
     */
    public function setMaxPositions($maxPositions)
    {
      $this->maxPositions = $maxPositions;
      return $this;
    }

}
