<?php

namespace Eurostop\Stocks;

class GetAdviceNotesByBranchBookedInDate
{

    /**
     * @var string $warehouseIdentifier
     */
    protected $warehouseIdentifier = null;

    /**
     * @var string $branchIdentifier
     */
    protected $branchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var \DateTime $bookedInFromDate
     */
    protected $bookedInFromDate = null;

    /**
     * @var \DateTime $bookedInToDate
     */
    protected $bookedInToDate = null;

    /**
     * @var AdviceNoteStatus $status
     */
    protected $status = null;

    /**
     * @var boolean $isClosed
     */
    protected $isClosed = null;

    /**
     * @param string $warehouseIdentifier
     * @param string $branchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param \DateTime $bookedInFromDate
     * @param \DateTime $bookedInToDate
     * @param AdviceNoteStatus $status
     * @param boolean $isClosed
     */
    public function __construct($warehouseIdentifier, $branchIdentifier, $branchIdentifierType, \DateTime $bookedInFromDate, \DateTime $bookedInToDate, $status, $isClosed)
    {
      $this->warehouseIdentifier = $warehouseIdentifier;
      $this->branchIdentifier = $branchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->bookedInFromDate = $bookedInFromDate->format(\DateTime::ATOM);
      $this->bookedInToDate = $bookedInToDate->format(\DateTime::ATOM);
      $this->status = $status;
      $this->isClosed = $isClosed;
    }

    /**
     * @return string
     */
    public function getWarehouseIdentifier()
    {
      return $this->warehouseIdentifier;
    }

    /**
     * @param string $warehouseIdentifier
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchBookedInDate
     */
    public function setWarehouseIdentifier($warehouseIdentifier)
    {
      $this->warehouseIdentifier = $warehouseIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->branchIdentifier;
    }

    /**
     * @param string $branchIdentifier
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchBookedInDate
     */
    public function setBranchIdentifier($branchIdentifier)
    {
      $this->branchIdentifier = $branchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchBookedInDate
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getBookedInFromDate()
    {
      if ($this->bookedInFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->bookedInFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $bookedInFromDate
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchBookedInDate
     */
    public function setBookedInFromDate(\DateTime $bookedInFromDate)
    {
      $this->bookedInFromDate = $bookedInFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getBookedInToDate()
    {
      if ($this->bookedInToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->bookedInToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $bookedInToDate
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchBookedInDate
     */
    public function setBookedInToDate(\DateTime $bookedInToDate)
    {
      $this->bookedInToDate = $bookedInToDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return AdviceNoteStatus
     */
    public function getStatus()
    {
      return $this->status;
    }

    /**
     * @param AdviceNoteStatus $status
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchBookedInDate
     */
    public function setStatus($status)
    {
      $this->status = $status;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsClosed()
    {
      return $this->isClosed;
    }

    /**
     * @param boolean $isClosed
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchBookedInDate
     */
    public function setIsClosed($isClosed)
    {
      $this->isClosed = $isClosed;
      return $this;
    }

}
