<?php

namespace Eurostop\Stocks;

class DataProcessingStatus
{

    /**
     * @var ArrayOfDataProcessingStatus $ChildItems
     */
    protected $ChildItems = null;

    /**
     * @var string $CustomIdentifier
     */
    protected $CustomIdentifier = null;

    /**
     * @var string $DataItemIdentifier
     */
    protected $DataItemIdentifier = null;

    /**
     * @var string $ItemDataType
     */
    protected $ItemDataType = null;

    /**
     * @var ProcessingStatus $ItemStatusCode
     */
    protected $ItemStatusCode = null;

    /**
     * @var string $ItemStatusDetails
     */
    protected $ItemStatusDetails = null;

    /**
     * @var string $SubmissionReference
     */
    protected $SubmissionReference = null;

    /**
     * @var string $SubmissionToken
     */
    protected $SubmissionToken = null;

    /**
     * @param ProcessingStatus $ItemStatusCode
     */
    public function __construct($ItemStatusCode)
    {
      $this->ItemStatusCode = $ItemStatusCode;
    }

    /**
     * @return ArrayOfDataProcessingStatus
     */
    public function getChildItems()
    {
      return $this->ChildItems;
    }

    /**
     * @param ArrayOfDataProcessingStatus $ChildItems
     * @return \Eurostop\Stocks\DataProcessingStatus
     */
    public function setChildItems($ChildItems)
    {
      $this->ChildItems = $ChildItems;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomIdentifier()
    {
      return $this->CustomIdentifier;
    }

    /**
     * @param string $CustomIdentifier
     * @return \Eurostop\Stocks\DataProcessingStatus
     */
    public function setCustomIdentifier($CustomIdentifier)
    {
      $this->CustomIdentifier = $CustomIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getDataItemIdentifier()
    {
      return $this->DataItemIdentifier;
    }

    /**
     * @param string $DataItemIdentifier
     * @return \Eurostop\Stocks\DataProcessingStatus
     */
    public function setDataItemIdentifier($DataItemIdentifier)
    {
      $this->DataItemIdentifier = $DataItemIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getItemDataType()
    {
      return $this->ItemDataType;
    }

    /**
     * @param string $ItemDataType
     * @return \Eurostop\Stocks\DataProcessingStatus
     */
    public function setItemDataType($ItemDataType)
    {
      $this->ItemDataType = $ItemDataType;
      return $this;
    }

    /**
     * @return ProcessingStatus
     */
    public function getItemStatusCode()
    {
      return $this->ItemStatusCode;
    }

    /**
     * @param ProcessingStatus $ItemStatusCode
     * @return \Eurostop\Stocks\DataProcessingStatus
     */
    public function setItemStatusCode($ItemStatusCode)
    {
      $this->ItemStatusCode = $ItemStatusCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getItemStatusDetails()
    {
      return $this->ItemStatusDetails;
    }

    /**
     * @param string $ItemStatusDetails
     * @return \Eurostop\Stocks\DataProcessingStatus
     */
    public function setItemStatusDetails($ItemStatusDetails)
    {
      $this->ItemStatusDetails = $ItemStatusDetails;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->SubmissionReference;
    }

    /**
     * @param string $SubmissionReference
     * @return \Eurostop\Stocks\DataProcessingStatus
     */
    public function setSubmissionReference($SubmissionReference)
    {
      $this->SubmissionReference = $SubmissionReference;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionToken()
    {
      return $this->SubmissionToken;
    }

    /**
     * @param string $SubmissionToken
     * @return \Eurostop\Stocks\DataProcessingStatus
     */
    public function setSubmissionToken($SubmissionToken)
    {
      $this->SubmissionToken = $SubmissionToken;
      return $this;
    }

}
