<?php

namespace Eurostop\Stocks;

class ArrayOfSubmittedTransferHeader implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var SubmittedTransferHeader[] $SubmittedTransferHeader
     */
    protected $SubmittedTransferHeader = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return SubmittedTransferHeader[]
     */
    public function getSubmittedTransferHeader()
    {
      return $this->SubmittedTransferHeader;
    }

    /**
     * @param SubmittedTransferHeader[] $SubmittedTransferHeader
     * @return \Eurostop\Stocks\ArrayOfSubmittedTransferHeader
     */
    public function setSubmittedTransferHeader(array $SubmittedTransferHeader = null)
    {
      $this->SubmittedTransferHeader = $SubmittedTransferHeader;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->SubmittedTransferHeader[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return SubmittedTransferHeader
     */
    public function offsetGet($offset)
    {
      return $this->SubmittedTransferHeader[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param SubmittedTransferHeader $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->SubmittedTransferHeader[] = $value;
      } else {
        $this->SubmittedTransferHeader[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->SubmittedTransferHeader[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return SubmittedTransferHeader Return the current element
     */
    public function current()
    {
      return current($this->SubmittedTransferHeader);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->SubmittedTransferHeader);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->SubmittedTransferHeader);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->SubmittedTransferHeader);
    }

    /**
     * Countable implementation
     *
     * @return SubmittedTransferHeader Return count of elements
     */
    public function count()
    {
      return count($this->SubmittedTransferHeader);
    }

}
