<?php

namespace Eurostop\Stocks;

class ArrayOfSubmittedTransferAction implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var SubmittedTransferAction[] $SubmittedTransferAction
     */
    protected $SubmittedTransferAction = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return SubmittedTransferAction[]
     */
    public function getSubmittedTransferAction()
    {
      return $this->SubmittedTransferAction;
    }

    /**
     * @param SubmittedTransferAction[] $SubmittedTransferAction
     * @return \Eurostop\Stocks\ArrayOfSubmittedTransferAction
     */
    public function setSubmittedTransferAction(array $SubmittedTransferAction = null)
    {
      $this->SubmittedTransferAction = $SubmittedTransferAction;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->SubmittedTransferAction[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return SubmittedTransferAction
     */
    public function offsetGet($offset)
    {
      return $this->SubmittedTransferAction[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param SubmittedTransferAction $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->SubmittedTransferAction[] = $value;
      } else {
        $this->SubmittedTransferAction[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->SubmittedTransferAction[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return SubmittedTransferAction Return the current element
     */
    public function current()
    {
      return current($this->SubmittedTransferAction);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->SubmittedTransferAction);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->SubmittedTransferAction);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->SubmittedTransferAction);
    }

    /**
     * Countable implementation
     *
     * @return SubmittedTransferAction Return count of elements
     */
    public function count()
    {
      return count($this->SubmittedTransferAction);
    }

}
