<?php

namespace Eurostop\Stocks;

class ArrayOfSubmittedDeliveryLine implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var SubmittedDeliveryLine[] $SubmittedDeliveryLine
     */
    protected $SubmittedDeliveryLine = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return SubmittedDeliveryLine[]
     */
    public function getSubmittedDeliveryLine()
    {
      return $this->SubmittedDeliveryLine;
    }

    /**
     * @param SubmittedDeliveryLine[] $SubmittedDeliveryLine
     * @return \Eurostop\Stocks\ArrayOfSubmittedDeliveryLine
     */
    public function setSubmittedDeliveryLine(array $SubmittedDeliveryLine = null)
    {
      $this->SubmittedDeliveryLine = $SubmittedDeliveryLine;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->SubmittedDeliveryLine[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return SubmittedDeliveryLine
     */
    public function offsetGet($offset)
    {
      return $this->SubmittedDeliveryLine[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param SubmittedDeliveryLine $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->SubmittedDeliveryLine[] = $value;
      } else {
        $this->SubmittedDeliveryLine[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->SubmittedDeliveryLine[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return SubmittedDeliveryLine Return the current element
     */
    public function current()
    {
      return current($this->SubmittedDeliveryLine);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->SubmittedDeliveryLine);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->SubmittedDeliveryLine);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->SubmittedDeliveryLine);
    }

    /**
     * Countable implementation
     *
     * @return SubmittedDeliveryLine Return count of elements
     */
    public function count()
    {
      return count($this->SubmittedDeliveryLine);
    }

}
