<?php

namespace Eurostop\Stocks;

class ArrayOfSubmittedAllocationItem implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var SubmittedAllocationItem[] $SubmittedAllocationItem
     */
    protected $SubmittedAllocationItem = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return SubmittedAllocationItem[]
     */
    public function getSubmittedAllocationItem()
    {
      return $this->SubmittedAllocationItem;
    }

    /**
     * @param SubmittedAllocationItem[] $SubmittedAllocationItem
     * @return \Eurostop\Stocks\ArrayOfSubmittedAllocationItem
     */
    public function setSubmittedAllocationItem(array $SubmittedAllocationItem = null)
    {
      $this->SubmittedAllocationItem = $SubmittedAllocationItem;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->SubmittedAllocationItem[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return SubmittedAllocationItem
     */
    public function offsetGet($offset)
    {
      return $this->SubmittedAllocationItem[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param SubmittedAllocationItem $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->SubmittedAllocationItem[] = $value;
      } else {
        $this->SubmittedAllocationItem[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->SubmittedAllocationItem[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return SubmittedAllocationItem Return the current element
     */
    public function current()
    {
      return current($this->SubmittedAllocationItem);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->SubmittedAllocationItem);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->SubmittedAllocationItem);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->SubmittedAllocationItem);
    }

    /**
     * Countable implementation
     *
     * @return SubmittedAllocationItem Return count of elements
     */
    public function count()
    {
      return count($this->SubmittedAllocationItem);
    }

}
