<?php

namespace Eurostop\Sales;

class SubmittedReceiptTaxCollection extends SubmittedDataItemOfSubmittedReceiptTaxCollectionDtonkuuQA70
{

    /**
     * @var int $LineNumber
     */
    protected $LineNumber = null;

    /**
     * @var string $TaxAuthorityIdentifier
     */
    protected $TaxAuthorityIdentifier = null;

    /**
     * @var TaxAuthorityIdentifierType $TaxAuthorityIdentifierType
     */
    protected $TaxAuthorityIdentifierType = null;

    /**
     * @var string $TaxRuleIdentifier
     */
    protected $TaxRuleIdentifier = null;

    /**
     * @var TaxRuleIdentifierType $TaxRuleIdentifierType
     */
    protected $TaxRuleIdentifierType = null;

    /**
     * @var string $TaxRateIdentifier
     */
    protected $TaxRateIdentifier = null;

    /**
     * @var TaxRateIdentifierType $TaxRateIdentifierType
     */
    protected $TaxRateIdentifierType = null;

    /**
     * @var float $TaxableAmount
     */
    protected $TaxableAmount = null;

    /**
     * @var float $TaxRuleRate
     */
    protected $TaxRuleRate = null;

    /**
     * @var boolean $IsExempted
     */
    protected $IsExempted = null;

    /**
     * @var float $TaxAmountCollected
     */
    protected $TaxAmountCollected = null;

    /**
     * @param float $TaxRuleRate
     * @param float $TaxAmountCollected
     */
    public function __construct($TaxRuleRate, $TaxAmountCollected)
    {
      parent::__construct();
      $this->TaxRuleRate = $TaxRuleRate;
      $this->TaxAmountCollected = $TaxAmountCollected;
    }

    /**
     * @return int
     */
    public function getLineNumber()
    {
      return $this->LineNumber;
    }

    /**
     * @param int $LineNumber
     * @return \Eurostop\Sales\SubmittedReceiptTaxCollection
     */
    public function setLineNumber($LineNumber)
    {
      $this->LineNumber = $LineNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getTaxAuthorityIdentifier()
    {
      return $this->TaxAuthorityIdentifier;
    }

    /**
     * @param string $TaxAuthorityIdentifier
     * @return \Eurostop\Sales\SubmittedReceiptTaxCollection
     */
    public function setTaxAuthorityIdentifier($TaxAuthorityIdentifier)
    {
      $this->TaxAuthorityIdentifier = $TaxAuthorityIdentifier;
      return $this;
    }

    /**
     * @return TaxAuthorityIdentifierType
     */
    public function getTaxAuthorityIdentifierType()
    {
      return $this->TaxAuthorityIdentifierType;
    }

    /**
     * @param TaxAuthorityIdentifierType $TaxAuthorityIdentifierType
     * @return \Eurostop\Sales\SubmittedReceiptTaxCollection
     */
    public function setTaxAuthorityIdentifierType($TaxAuthorityIdentifierType)
    {
      $this->TaxAuthorityIdentifierType = $TaxAuthorityIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getTaxRuleIdentifier()
    {
      return $this->TaxRuleIdentifier;
    }

    /**
     * @param string $TaxRuleIdentifier
     * @return \Eurostop\Sales\SubmittedReceiptTaxCollection
     */
    public function setTaxRuleIdentifier($TaxRuleIdentifier)
    {
      $this->TaxRuleIdentifier = $TaxRuleIdentifier;
      return $this;
    }

    /**
     * @return TaxRuleIdentifierType
     */
    public function getTaxRuleIdentifierType()
    {
      return $this->TaxRuleIdentifierType;
    }

    /**
     * @param TaxRuleIdentifierType $TaxRuleIdentifierType
     * @return \Eurostop\Sales\SubmittedReceiptTaxCollection
     */
    public function setTaxRuleIdentifierType($TaxRuleIdentifierType)
    {
      $this->TaxRuleIdentifierType = $TaxRuleIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getTaxRateIdentifier()
    {
      return $this->TaxRateIdentifier;
    }

    /**
     * @param string $TaxRateIdentifier
     * @return \Eurostop\Sales\SubmittedReceiptTaxCollection
     */
    public function setTaxRateIdentifier($TaxRateIdentifier)
    {
      $this->TaxRateIdentifier = $TaxRateIdentifier;
      return $this;
    }

    /**
     * @return TaxRateIdentifierType
     */
    public function getTaxRateIdentifierType()
    {
      return $this->TaxRateIdentifierType;
    }

    /**
     * @param TaxRateIdentifierType $TaxRateIdentifierType
     * @return \Eurostop\Sales\SubmittedReceiptTaxCollection
     */
    public function setTaxRateIdentifierType($TaxRateIdentifierType)
    {
      $this->TaxRateIdentifierType = $TaxRateIdentifierType;
      return $this;
    }

    /**
     * @return float
     */
    public function getTaxableAmount()
    {
      return $this->TaxableAmount;
    }

    /**
     * @param float $TaxableAmount
     * @return \Eurostop\Sales\SubmittedReceiptTaxCollection
     */
    public function setTaxableAmount($TaxableAmount)
    {
      $this->TaxableAmount = $TaxableAmount;
      return $this;
    }

    /**
     * @return float
     */
    public function getTaxRuleRate()
    {
      return $this->TaxRuleRate;
    }

    /**
     * @param float $TaxRuleRate
     * @return \Eurostop\Sales\SubmittedReceiptTaxCollection
     */
    public function setTaxRuleRate($TaxRuleRate)
    {
      $this->TaxRuleRate = $TaxRuleRate;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsExempted()
    {
      return $this->IsExempted;
    }

    /**
     * @param boolean $IsExempted
     * @return \Eurostop\Sales\SubmittedReceiptTaxCollection
     */
    public function setIsExempted($IsExempted)
    {
      $this->IsExempted = $IsExempted;
      return $this;
    }

    /**
     * @return float
     */
    public function getTaxAmountCollected()
    {
      return $this->TaxAmountCollected;
    }

    /**
     * @param float $TaxAmountCollected
     * @return \Eurostop\Sales\SubmittedReceiptTaxCollection
     */
    public function setTaxAmountCollected($TaxAmountCollected)
    {
      $this->TaxAmountCollected = $TaxAmountCollected;
      return $this;
    }

}
