<?php

namespace Eurostop\Sales;

class SubmittedReceiptHeader extends SubmittedDataItemOfSubmittedReceiptHeaderDtonkuuQA70
{

    /**
     * @var string $AssistantUsername
     */
    protected $AssistantUsername = null;

    /**
     * @var DateTimeOffset $BeginDateTime
     */
    protected $BeginDateTime = null;

    /**
     * @var string $BranchIdentifier
     */
    protected $BranchIdentifier = null;

    /**
     * @var BranchIdentifierType $BranchIdentifierType
     */
    protected $BranchIdentifierType = null;

    /**
     * @var string $CustomerIdentifier
     */
    protected $CustomerIdentifier = null;

    /**
     * @var CustomerIdentifierType $CustomerIdentifierType
     */
    protected $CustomerIdentifierType = null;

    /**
     * @var string $CustomerOrderIdentifier
     */
    protected $CustomerOrderIdentifier = null;

    /**
     * @var CustomerOrderIdentifierType $CustomerOrderIdentifierType
     */
    protected $CustomerOrderIdentifierType = null;

    /**
     * @var DateTimeOffset $EndDateTime
     */
    protected $EndDateTime = null;

    /**
     * @var ArrayOfSubmittedReceiptGiftCardTransaction $GiftCardTransactions
     */
    protected $GiftCardTransactions = null;

    /**
     * @var ArrayOfSubmittedReceiptLineSku $Lines
     */
    protected $Lines = null;

    /**
     * @var string $LinkedReceiptBranchIdentifier
     */
    protected $LinkedReceiptBranchIdentifier = null;

    /**
     * @var string $LinkedReceiptIdentifier
     */
    protected $LinkedReceiptIdentifier = null;

    /**
     * @var int $LinkedReceiptTillNumber
     */
    protected $LinkedReceiptTillNumber = null;

    /**
     * @var ArrayOfSubmittedReceiptOperation $Operations
     */
    protected $Operations = null;

    /**
     * @var ArrayOfSubmittedReceiptPriceModifier $PriceModifiers
     */
    protected $PriceModifiers = null;

    /**
     * @var string $ReceiptIdentifier
     */
    protected $ReceiptIdentifier = null;

    /**
     * @var ReceiptIdentifierType $ReceiptIdentifierType
     */
    protected $ReceiptIdentifierType = null;

    /**
     * @var ReceiptStatus $ReceiptStatus
     */
    protected $ReceiptStatus = null;

    /**
     * @var TillOperationType $ReceiptType
     */
    protected $ReceiptType = null;

    /**
     * @var ArrayOfSubmittedReceiptTender $Tenders
     */
    protected $Tenders = null;

    /**
     * @var int $TillNumber
     */
    protected $TillNumber = null;

    /**
     * @var boolean $TransactionVoid
     */
    protected $TransactionVoid = null;

    /**
     * @var ArrayOfSubmittedReceiptVoucherPurchase $VoucherPurchases
     */
    protected $VoucherPurchases = null;

    /**
     * @var ArrayOfSubmittedReceiptTaxCollection $TaxCollected
     */
    protected $TaxCollected = null;

    /**
     * @param DateTimeOffset $BeginDateTime
     * @param DateTimeOffset $EndDateTime
     * @param ReceiptIdentifierType $ReceiptIdentifierType
     * @param ReceiptStatus $ReceiptStatus
     * @param TillOperationType $ReceiptType
     * @param int $TillNumber
     */
    public function __construct($BeginDateTime, $EndDateTime, $ReceiptIdentifierType, $ReceiptStatus, $ReceiptType, $TillNumber)
    {
      parent::__construct();
      $this->BeginDateTime = $BeginDateTime;
      $this->EndDateTime = $EndDateTime;
      $this->ReceiptIdentifierType = $ReceiptIdentifierType;
      $this->ReceiptStatus = $ReceiptStatus;
      $this->ReceiptType = $ReceiptType;
      $this->TillNumber = $TillNumber;
    }

    /**
     * @return string
     */
    public function getAssistantUsername()
    {
      return $this->AssistantUsername;
    }

    /**
     * @param string $AssistantUsername
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setAssistantUsername($AssistantUsername)
    {
      $this->AssistantUsername = $AssistantUsername;
      return $this;
    }

    /**
     * @return DateTimeOffset
     */
    public function getBeginDateTime()
    {
      return $this->BeginDateTime;
    }

    /**
     * @param DateTimeOffset $BeginDateTime
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setBeginDateTime($BeginDateTime)
    {
      $this->BeginDateTime = $BeginDateTime;
      return $this;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->BranchIdentifier;
    }

    /**
     * @param string $BranchIdentifier
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setBranchIdentifier($BranchIdentifier)
    {
      $this->BranchIdentifier = $BranchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->BranchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $BranchIdentifierType
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setBranchIdentifierType($BranchIdentifierType)
    {
      $this->BranchIdentifierType = $BranchIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerIdentifier()
    {
      return $this->CustomerIdentifier;
    }

    /**
     * @param string $CustomerIdentifier
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setCustomerIdentifier($CustomerIdentifier)
    {
      $this->CustomerIdentifier = $CustomerIdentifier;
      return $this;
    }

    /**
     * @return CustomerIdentifierType
     */
    public function getCustomerIdentifierType()
    {
      return $this->CustomerIdentifierType;
    }

    /**
     * @param CustomerIdentifierType $CustomerIdentifierType
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setCustomerIdentifierType($CustomerIdentifierType)
    {
      $this->CustomerIdentifierType = $CustomerIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerOrderIdentifier()
    {
      return $this->CustomerOrderIdentifier;
    }

    /**
     * @param string $CustomerOrderIdentifier
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setCustomerOrderIdentifier($CustomerOrderIdentifier)
    {
      $this->CustomerOrderIdentifier = $CustomerOrderIdentifier;
      return $this;
    }

    /**
     * @return CustomerOrderIdentifierType
     */
    public function getCustomerOrderIdentifierType()
    {
      return $this->CustomerOrderIdentifierType;
    }

    /**
     * @param CustomerOrderIdentifierType $CustomerOrderIdentifierType
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setCustomerOrderIdentifierType($CustomerOrderIdentifierType)
    {
      $this->CustomerOrderIdentifierType = $CustomerOrderIdentifierType;
      return $this;
    }

    /**
     * @return DateTimeOffset
     */
    public function getEndDateTime()
    {
      return $this->EndDateTime;
    }

    /**
     * @param DateTimeOffset $EndDateTime
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setEndDateTime($EndDateTime)
    {
      $this->EndDateTime = $EndDateTime;
      return $this;
    }

    /**
     * @return ArrayOfSubmittedReceiptGiftCardTransaction
     */
    public function getGiftCardTransactions()
    {
      return $this->GiftCardTransactions;
    }

    /**
     * @param ArrayOfSubmittedReceiptGiftCardTransaction $GiftCardTransactions
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setGiftCardTransactions($GiftCardTransactions)
    {
      $this->GiftCardTransactions = $GiftCardTransactions;
      return $this;
    }

    /**
     * @return ArrayOfSubmittedReceiptLineSku
     */
    public function getLines()
    {
      return $this->Lines;
    }

    /**
     * @param ArrayOfSubmittedReceiptLineSku $Lines
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setLines($Lines)
    {
      $this->Lines = $Lines;
      return $this;
    }

    /**
     * @return string
     */
    public function getLinkedReceiptBranchIdentifier()
    {
      return $this->LinkedReceiptBranchIdentifier;
    }

    /**
     * @param string $LinkedReceiptBranchIdentifier
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setLinkedReceiptBranchIdentifier($LinkedReceiptBranchIdentifier)
    {
      $this->LinkedReceiptBranchIdentifier = $LinkedReceiptBranchIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getLinkedReceiptIdentifier()
    {
      return $this->LinkedReceiptIdentifier;
    }

    /**
     * @param string $LinkedReceiptIdentifier
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setLinkedReceiptIdentifier($LinkedReceiptIdentifier)
    {
      $this->LinkedReceiptIdentifier = $LinkedReceiptIdentifier;
      return $this;
    }

    /**
     * @return int
     */
    public function getLinkedReceiptTillNumber()
    {
      return $this->LinkedReceiptTillNumber;
    }

    /**
     * @param int $LinkedReceiptTillNumber
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setLinkedReceiptTillNumber($LinkedReceiptTillNumber)
    {
      $this->LinkedReceiptTillNumber = $LinkedReceiptTillNumber;
      return $this;
    }

    /**
     * @return ArrayOfSubmittedReceiptOperation
     */
    public function getOperations()
    {
      return $this->Operations;
    }

    /**
     * @param ArrayOfSubmittedReceiptOperation $Operations
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setOperations($Operations)
    {
      $this->Operations = $Operations;
      return $this;
    }

    /**
     * @return ArrayOfSubmittedReceiptPriceModifier
     */
    public function getPriceModifiers()
    {
      return $this->PriceModifiers;
    }

    /**
     * @param ArrayOfSubmittedReceiptPriceModifier $PriceModifiers
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setPriceModifiers($PriceModifiers)
    {
      $this->PriceModifiers = $PriceModifiers;
      return $this;
    }

    /**
     * @return string
     */
    public function getReceiptIdentifier()
    {
      return $this->ReceiptIdentifier;
    }

    /**
     * @param string $ReceiptIdentifier
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setReceiptIdentifier($ReceiptIdentifier)
    {
      $this->ReceiptIdentifier = $ReceiptIdentifier;
      return $this;
    }

    /**
     * @return ReceiptIdentifierType
     */
    public function getReceiptIdentifierType()
    {
      return $this->ReceiptIdentifierType;
    }

    /**
     * @param ReceiptIdentifierType $ReceiptIdentifierType
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setReceiptIdentifierType($ReceiptIdentifierType)
    {
      $this->ReceiptIdentifierType = $ReceiptIdentifierType;
      return $this;
    }

    /**
     * @return ReceiptStatus
     */
    public function getReceiptStatus()
    {
      return $this->ReceiptStatus;
    }

    /**
     * @param ReceiptStatus $ReceiptStatus
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setReceiptStatus($ReceiptStatus)
    {
      $this->ReceiptStatus = $ReceiptStatus;
      return $this;
    }

    /**
     * @return TillOperationType
     */
    public function getReceiptType()
    {
      return $this->ReceiptType;
    }

    /**
     * @param TillOperationType $ReceiptType
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setReceiptType($ReceiptType)
    {
      $this->ReceiptType = $ReceiptType;
      return $this;
    }

    /**
     * @return ArrayOfSubmittedReceiptTender
     */
    public function getTenders()
    {
      return $this->Tenders;
    }

    /**
     * @param ArrayOfSubmittedReceiptTender $Tenders
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setTenders($Tenders)
    {
      $this->Tenders = $Tenders;
      return $this;
    }

    /**
     * @return int
     */
    public function getTillNumber()
    {
      return $this->TillNumber;
    }

    /**
     * @param int $TillNumber
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setTillNumber($TillNumber)
    {
      $this->TillNumber = $TillNumber;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getTransactionVoid()
    {
      return $this->TransactionVoid;
    }

    /**
     * @param boolean $TransactionVoid
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setTransactionVoid($TransactionVoid)
    {
      $this->TransactionVoid = $TransactionVoid;
      return $this;
    }

    /**
     * @return ArrayOfSubmittedReceiptVoucherPurchase
     */
    public function getVoucherPurchases()
    {
      return $this->VoucherPurchases;
    }

    /**
     * @param ArrayOfSubmittedReceiptVoucherPurchase $VoucherPurchases
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setVoucherPurchases($VoucherPurchases)
    {
      $this->VoucherPurchases = $VoucherPurchases;
      return $this;
    }

    /**
     * @return ArrayOfSubmittedReceiptTaxCollection
     */
    public function getTaxCollected()
    {
      return $this->TaxCollected;
    }

    /**
     * @param ArrayOfSubmittedReceiptTaxCollection $TaxCollected
     * @return \Eurostop\Sales\SubmittedReceiptHeader
     */
    public function setTaxCollected($TaxCollected)
    {
      $this->TaxCollected = $TaxCollected;
      return $this;
    }

}
