<?php

namespace Eurostop\Sales;

class SerialisedVoucherStatus extends RetrievedDataItemOfSerialisedVoucherStatusDtonkuuQA70
{

    /**
     * @var string $BranchIdentifier
     */
    protected $BranchIdentifier = null;

    /**
     * @var boolean $IsSold
     */
    protected $IsSold = null;

    /**
     * @var \DateTime $LockExpiryTime
     */
    protected $LockExpiryTime = null;

    /**
     * @var string $LockToken
     */
    protected $LockToken = null;

    /**
     * @var float $RedeemedValue
     */
    protected $RedeemedValue = null;

    /**
     * @var float $RemainingValue
     */
    protected $RemainingValue = null;

    /**
     * @var int $TillNumber
     */
    protected $TillNumber = null;

    /**
     * @var string $VoucherNumber
     */
    protected $VoucherNumber = null;

    /**
     * @var float $VoucherValue
     */
    protected $VoucherValue = null;

    /**
     * @param boolean $IsSold
     * @param float $RedeemedValue
     * @param float $RemainingValue
     * @param int $TillNumber
     * @param float $VoucherValue
     */
    public function __construct($IsSold, $RedeemedValue, $RemainingValue, $TillNumber, $VoucherValue)
    {
      parent::__construct();
      $this->IsSold = $IsSold;
      $this->RedeemedValue = $RedeemedValue;
      $this->RemainingValue = $RemainingValue;
      $this->TillNumber = $TillNumber;
      $this->VoucherValue = $VoucherValue;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->BranchIdentifier;
    }

    /**
     * @param string $BranchIdentifier
     * @return \Eurostop\Sales\SerialisedVoucherStatus
     */
    public function setBranchIdentifier($BranchIdentifier)
    {
      $this->BranchIdentifier = $BranchIdentifier;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsSold()
    {
      return $this->IsSold;
    }

    /**
     * @param boolean $IsSold
     * @return \Eurostop\Sales\SerialisedVoucherStatus
     */
    public function setIsSold($IsSold)
    {
      $this->IsSold = $IsSold;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLockExpiryTime()
    {
      if ($this->LockExpiryTime == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LockExpiryTime);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LockExpiryTime
     * @return \Eurostop\Sales\SerialisedVoucherStatus
     */
    public function setLockExpiryTime(\DateTime $LockExpiryTime = null)
    {
      if ($LockExpiryTime == null) {
       $this->LockExpiryTime = null;
      } else {
        $this->LockExpiryTime = $LockExpiryTime->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getLockToken()
    {
      return $this->LockToken;
    }

    /**
     * @param string $LockToken
     * @return \Eurostop\Sales\SerialisedVoucherStatus
     */
    public function setLockToken($LockToken)
    {
      $this->LockToken = $LockToken;
      return $this;
    }

    /**
     * @return float
     */
    public function getRedeemedValue()
    {
      return $this->RedeemedValue;
    }

    /**
     * @param float $RedeemedValue
     * @return \Eurostop\Sales\SerialisedVoucherStatus
     */
    public function setRedeemedValue($RedeemedValue)
    {
      $this->RedeemedValue = $RedeemedValue;
      return $this;
    }

    /**
     * @return float
     */
    public function getRemainingValue()
    {
      return $this->RemainingValue;
    }

    /**
     * @param float $RemainingValue
     * @return \Eurostop\Sales\SerialisedVoucherStatus
     */
    public function setRemainingValue($RemainingValue)
    {
      $this->RemainingValue = $RemainingValue;
      return $this;
    }

    /**
     * @return int
     */
    public function getTillNumber()
    {
      return $this->TillNumber;
    }

    /**
     * @param int $TillNumber
     * @return \Eurostop\Sales\SerialisedVoucherStatus
     */
    public function setTillNumber($TillNumber)
    {
      $this->TillNumber = $TillNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getVoucherNumber()
    {
      return $this->VoucherNumber;
    }

    /**
     * @param string $VoucherNumber
     * @return \Eurostop\Sales\SerialisedVoucherStatus
     */
    public function setVoucherNumber($VoucherNumber)
    {
      $this->VoucherNumber = $VoucherNumber;
      return $this;
    }

    /**
     * @return float
     */
    public function getVoucherValue()
    {
      return $this->VoucherValue;
    }

    /**
     * @param float $VoucherValue
     * @return \Eurostop\Sales\SerialisedVoucherStatus
     */
    public function setVoucherValue($VoucherValue)
    {
      $this->VoucherValue = $VoucherValue;
      return $this;
    }

}
