<?php

namespace Eurostop\Sales;

class ReceiptTaxCollection extends RetrievedDataItemOfReceiptTaxCollectionDtonkuuQA70
{

    /**
     * @var int $LineNumber
     */
    protected $LineNumber = null;

    /**
     * @var float $TaxableAmount
     */
    protected $TaxableAmount = null;

    /**
     * @var boolean $IsExempted
     */
    protected $IsExempted = null;

    /**
     * @var float $TaxAmountCollected
     */
    protected $TaxAmountCollected = null;

    /**
     * @var string $TaxAuthorityIdentifier
     */
    protected $TaxAuthorityIdentifier = null;

    /**
     * @var string $TaxRuleIdentifier
     */
    protected $TaxRuleIdentifier = null;

    /**
     * @var string $TaxRateIdentifier
     */
    protected $TaxRateIdentifier = null;

    /**
     * @var float $TaxRuleRate
     */
    protected $TaxRuleRate = null;

    /**
     * @param boolean $IsExempted
     * @param float $TaxAmountCollected
     * @param float $TaxRuleRate
     */
    public function __construct($IsExempted, $TaxAmountCollected, $TaxRuleRate)
    {
      parent::__construct();
      $this->IsExempted = $IsExempted;
      $this->TaxAmountCollected = $TaxAmountCollected;
      $this->TaxRuleRate = $TaxRuleRate;
    }

    /**
     * @return int
     */
    public function getLineNumber()
    {
      return $this->LineNumber;
    }

    /**
     * @param int $LineNumber
     * @return \Eurostop\Sales\ReceiptTaxCollection
     */
    public function setLineNumber($LineNumber)
    {
      $this->LineNumber = $LineNumber;
      return $this;
    }

    /**
     * @return float
     */
    public function getTaxableAmount()
    {
      return $this->TaxableAmount;
    }

    /**
     * @param float $TaxableAmount
     * @return \Eurostop\Sales\ReceiptTaxCollection
     */
    public function setTaxableAmount($TaxableAmount)
    {
      $this->TaxableAmount = $TaxableAmount;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsExempted()
    {
      return $this->IsExempted;
    }

    /**
     * @param boolean $IsExempted
     * @return \Eurostop\Sales\ReceiptTaxCollection
     */
    public function setIsExempted($IsExempted)
    {
      $this->IsExempted = $IsExempted;
      return $this;
    }

    /**
     * @return float
     */
    public function getTaxAmountCollected()
    {
      return $this->TaxAmountCollected;
    }

    /**
     * @param float $TaxAmountCollected
     * @return \Eurostop\Sales\ReceiptTaxCollection
     */
    public function setTaxAmountCollected($TaxAmountCollected)
    {
      $this->TaxAmountCollected = $TaxAmountCollected;
      return $this;
    }

    /**
     * @return string
     */
    public function getTaxAuthorityIdentifier()
    {
      return $this->TaxAuthorityIdentifier;
    }

    /**
     * @param string $TaxAuthorityIdentifier
     * @return \Eurostop\Sales\ReceiptTaxCollection
     */
    public function setTaxAuthorityIdentifier($TaxAuthorityIdentifier)
    {
      $this->TaxAuthorityIdentifier = $TaxAuthorityIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getTaxRuleIdentifier()
    {
      return $this->TaxRuleIdentifier;
    }

    /**
     * @param string $TaxRuleIdentifier
     * @return \Eurostop\Sales\ReceiptTaxCollection
     */
    public function setTaxRuleIdentifier($TaxRuleIdentifier)
    {
      $this->TaxRuleIdentifier = $TaxRuleIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getTaxRateIdentifier()
    {
      return $this->TaxRateIdentifier;
    }

    /**
     * @param string $TaxRateIdentifier
     * @return \Eurostop\Sales\ReceiptTaxCollection
     */
    public function setTaxRateIdentifier($TaxRateIdentifier)
    {
      $this->TaxRateIdentifier = $TaxRateIdentifier;
      return $this;
    }

    /**
     * @return float
     */
    public function getTaxRuleRate()
    {
      return $this->TaxRuleRate;
    }

    /**
     * @param float $TaxRuleRate
     * @return \Eurostop\Sales\ReceiptTaxCollection
     */
    public function setTaxRuleRate($TaxRuleRate)
    {
      $this->TaxRuleRate = $TaxRuleRate;
      return $this;
    }

}
