<?php

namespace Eurostop\Sales;

class ReceiptOperation extends RetrievedDataItemOfReceiptOperationDtonkuuQA70
{

    /**
     * @var string $CurrencyIdentifier
     */
    protected $CurrencyIdentifier = null;

    /**
     * @var TillOperationSubType $OperationSubType
     */
    protected $OperationSubType = null;

    /**
     * @var string $TypeCode
     */
    protected $TypeCode = null;

    /**
     * @var string $TypeDescription
     */
    protected $TypeDescription = null;

    /**
     * @var string $TypeSubCode
     */
    protected $TypeSubCode = null;

    /**
     * @var float $Value
     */
    protected $Value = null;

    /**
     * @var string $VatCode
     */
    protected $VatCode = null;

    /**
     * @param TillOperationSubType $OperationSubType
     * @param float $Value
     */
    public function __construct($OperationSubType, $Value)
    {
      parent::__construct();
      $this->OperationSubType = $OperationSubType;
      $this->Value = $Value;
    }

    /**
     * @return string
     */
    public function getCurrencyIdentifier()
    {
      return $this->CurrencyIdentifier;
    }

    /**
     * @param string $CurrencyIdentifier
     * @return \Eurostop\Sales\ReceiptOperation
     */
    public function setCurrencyIdentifier($CurrencyIdentifier)
    {
      $this->CurrencyIdentifier = $CurrencyIdentifier;
      return $this;
    }

    /**
     * @return TillOperationSubType
     */
    public function getOperationSubType()
    {
      return $this->OperationSubType;
    }

    /**
     * @param TillOperationSubType $OperationSubType
     * @return \Eurostop\Sales\ReceiptOperation
     */
    public function setOperationSubType($OperationSubType)
    {
      $this->OperationSubType = $OperationSubType;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeCode()
    {
      return $this->TypeCode;
    }

    /**
     * @param string $TypeCode
     * @return \Eurostop\Sales\ReceiptOperation
     */
    public function setTypeCode($TypeCode)
    {
      $this->TypeCode = $TypeCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeDescription()
    {
      return $this->TypeDescription;
    }

    /**
     * @param string $TypeDescription
     * @return \Eurostop\Sales\ReceiptOperation
     */
    public function setTypeDescription($TypeDescription)
    {
      $this->TypeDescription = $TypeDescription;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeSubCode()
    {
      return $this->TypeSubCode;
    }

    /**
     * @param string $TypeSubCode
     * @return \Eurostop\Sales\ReceiptOperation
     */
    public function setTypeSubCode($TypeSubCode)
    {
      $this->TypeSubCode = $TypeSubCode;
      return $this;
    }

    /**
     * @return float
     */
    public function getValue()
    {
      return $this->Value;
    }

    /**
     * @param float $Value
     * @return \Eurostop\Sales\ReceiptOperation
     */
    public function setValue($Value)
    {
      $this->Value = $Value;
      return $this;
    }

    /**
     * @return string
     */
    public function getVatCode()
    {
      return $this->VatCode;
    }

    /**
     * @param string $VatCode
     * @return \Eurostop\Sales\ReceiptOperation
     */
    public function setVatCode($VatCode)
    {
      $this->VatCode = $VatCode;
      return $this;
    }

}
