<?php

namespace Eurostop\Sales;

class ReceiptLinePriceModifier extends RetrievedDataItemOfReceiptLinePriceModifierDtonkuuQA70
{

    /**
     * @var int $EntryOrder
     */
    protected $EntryOrder = null;

    /**
     * @var boolean $FixedDiscount
     */
    protected $FixedDiscount = null;

    /**
     * @var boolean $IsLineNotTransactionLevel
     */
    protected $IsLineNotTransactionLevel = null;

    /**
     * @var boolean $IsStaffDiscount
     */
    protected $IsStaffDiscount = null;

    /**
     * @var int $LineNumber
     */
    protected $LineNumber = null;

    /**
     * @var float $MaxDiscount
     */
    protected $MaxDiscount = null;

    /**
     * @var PriceModifierType $PriceModifierType
     */
    protected $PriceModifierType = null;

    /**
     * @var string $PromotionCode
     */
    protected $PromotionCode = null;

    /**
     * @var string $PromotionName
     */
    protected $PromotionName = null;

    /**
     * @var string $TypeCode
     */
    protected $TypeCode = null;

    /**
     * @var string $TypeDescription
     */
    protected $TypeDescription = null;

    /**
     * @var string $TypeSubCode
     */
    protected $TypeSubCode = null;

    /**
     * @var float $Value
     */
    protected $Value = null;

    /**
     * @param int $EntryOrder
     * @param boolean $FixedDiscount
     * @param boolean $IsLineNotTransactionLevel
     * @param boolean $IsStaffDiscount
     * @param int $LineNumber
     * @param PriceModifierType $PriceModifierType
     * @param float $Value
     */
    public function __construct($EntryOrder, $FixedDiscount, $IsLineNotTransactionLevel, $IsStaffDiscount, $LineNumber, $PriceModifierType, $Value)
    {
      parent::__construct();
      $this->EntryOrder = $EntryOrder;
      $this->FixedDiscount = $FixedDiscount;
      $this->IsLineNotTransactionLevel = $IsLineNotTransactionLevel;
      $this->IsStaffDiscount = $IsStaffDiscount;
      $this->LineNumber = $LineNumber;
      $this->PriceModifierType = $PriceModifierType;
      $this->Value = $Value;
    }

    /**
     * @return int
     */
    public function getEntryOrder()
    {
      return $this->EntryOrder;
    }

    /**
     * @param int $EntryOrder
     * @return \Eurostop\Sales\ReceiptLinePriceModifier
     */
    public function setEntryOrder($EntryOrder)
    {
      $this->EntryOrder = $EntryOrder;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getFixedDiscount()
    {
      return $this->FixedDiscount;
    }

    /**
     * @param boolean $FixedDiscount
     * @return \Eurostop\Sales\ReceiptLinePriceModifier
     */
    public function setFixedDiscount($FixedDiscount)
    {
      $this->FixedDiscount = $FixedDiscount;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsLineNotTransactionLevel()
    {
      return $this->IsLineNotTransactionLevel;
    }

    /**
     * @param boolean $IsLineNotTransactionLevel
     * @return \Eurostop\Sales\ReceiptLinePriceModifier
     */
    public function setIsLineNotTransactionLevel($IsLineNotTransactionLevel)
    {
      $this->IsLineNotTransactionLevel = $IsLineNotTransactionLevel;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsStaffDiscount()
    {
      return $this->IsStaffDiscount;
    }

    /**
     * @param boolean $IsStaffDiscount
     * @return \Eurostop\Sales\ReceiptLinePriceModifier
     */
    public function setIsStaffDiscount($IsStaffDiscount)
    {
      $this->IsStaffDiscount = $IsStaffDiscount;
      return $this;
    }

    /**
     * @return int
     */
    public function getLineNumber()
    {
      return $this->LineNumber;
    }

    /**
     * @param int $LineNumber
     * @return \Eurostop\Sales\ReceiptLinePriceModifier
     */
    public function setLineNumber($LineNumber)
    {
      $this->LineNumber = $LineNumber;
      return $this;
    }

    /**
     * @return float
     */
    public function getMaxDiscount()
    {
      return $this->MaxDiscount;
    }

    /**
     * @param float $MaxDiscount
     * @return \Eurostop\Sales\ReceiptLinePriceModifier
     */
    public function setMaxDiscount($MaxDiscount)
    {
      $this->MaxDiscount = $MaxDiscount;
      return $this;
    }

    /**
     * @return PriceModifierType
     */
    public function getPriceModifierType()
    {
      return $this->PriceModifierType;
    }

    /**
     * @param PriceModifierType $PriceModifierType
     * @return \Eurostop\Sales\ReceiptLinePriceModifier
     */
    public function setPriceModifierType($PriceModifierType)
    {
      $this->PriceModifierType = $PriceModifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getPromotionCode()
    {
      return $this->PromotionCode;
    }

    /**
     * @param string $PromotionCode
     * @return \Eurostop\Sales\ReceiptLinePriceModifier
     */
    public function setPromotionCode($PromotionCode)
    {
      $this->PromotionCode = $PromotionCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getPromotionName()
    {
      return $this->PromotionName;
    }

    /**
     * @param string $PromotionName
     * @return \Eurostop\Sales\ReceiptLinePriceModifier
     */
    public function setPromotionName($PromotionName)
    {
      $this->PromotionName = $PromotionName;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeCode()
    {
      return $this->TypeCode;
    }

    /**
     * @param string $TypeCode
     * @return \Eurostop\Sales\ReceiptLinePriceModifier
     */
    public function setTypeCode($TypeCode)
    {
      $this->TypeCode = $TypeCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeDescription()
    {
      return $this->TypeDescription;
    }

    /**
     * @param string $TypeDescription
     * @return \Eurostop\Sales\ReceiptLinePriceModifier
     */
    public function setTypeDescription($TypeDescription)
    {
      $this->TypeDescription = $TypeDescription;
      return $this;
    }

    /**
     * @return string
     */
    public function getTypeSubCode()
    {
      return $this->TypeSubCode;
    }

    /**
     * @param string $TypeSubCode
     * @return \Eurostop\Sales\ReceiptLinePriceModifier
     */
    public function setTypeSubCode($TypeSubCode)
    {
      $this->TypeSubCode = $TypeSubCode;
      return $this;
    }

    /**
     * @return float
     */
    public function getValue()
    {
      return $this->Value;
    }

    /**
     * @param float $Value
     * @return \Eurostop\Sales\ReceiptLinePriceModifier
     */
    public function setValue($Value)
    {
      $this->Value = $Value;
      return $this;
    }

}
