<?php

namespace Eurostop\Products;

class SubmittedAnalysisValueAction extends SubmittedDataActionOfSubmittedAnalysisValueActionDtoVNxenGD6
{

    /**
     * @var AnalysisValueAction $ActionType
     */
    protected $ActionType = null;

    /**
     * @var string $AnalysisTypeIdentifier
     */
    protected $AnalysisTypeIdentifier = null;

    /**
     * @var AnalysisTypeIdentifierType $AnalysisTypeIdentifierType
     */
    protected $AnalysisTypeIdentifierType = null;

    /**
     * @var string $AnalysisValueIdentifier
     */
    protected $AnalysisValueIdentifier = null;

    /**
     * @var AnalysisValueIdentifierType $AnalysisValueIdentifierType
     */
    protected $AnalysisValueIdentifierType = null;

    /**
     * @var boolean $AppliesToProducts
     */
    protected $AppliesToProducts = null;

    /**
     * @var boolean $AppliesToSkus
     */
    protected $AppliesToSkus = null;

    /**
     * @param AnalysisValueAction $ActionType
     * @param boolean $AppliesToProducts
     * @param boolean $AppliesToSkus
     */
    public function __construct($ActionType, $AppliesToProducts, $AppliesToSkus)
    {
      parent::__construct();
      $this->ActionType = $ActionType;
      $this->AppliesToProducts = $AppliesToProducts;
      $this->AppliesToSkus = $AppliesToSkus;
    }

    /**
     * @return AnalysisValueAction
     */
    public function getActionType()
    {
      return $this->ActionType;
    }

    /**
     * @param AnalysisValueAction $ActionType
     * @return \Eurostop\Products\SubmittedAnalysisValueAction
     */
    public function setActionType($ActionType)
    {
      $this->ActionType = $ActionType;
      return $this;
    }

    /**
     * @return string
     */
    public function getAnalysisTypeIdentifier()
    {
      return $this->AnalysisTypeIdentifier;
    }

    /**
     * @param string $AnalysisTypeIdentifier
     * @return \Eurostop\Products\SubmittedAnalysisValueAction
     */
    public function setAnalysisTypeIdentifier($AnalysisTypeIdentifier)
    {
      $this->AnalysisTypeIdentifier = $AnalysisTypeIdentifier;
      return $this;
    }

    /**
     * @return AnalysisTypeIdentifierType
     */
    public function getAnalysisTypeIdentifierType()
    {
      return $this->AnalysisTypeIdentifierType;
    }

    /**
     * @param AnalysisTypeIdentifierType $AnalysisTypeIdentifierType
     * @return \Eurostop\Products\SubmittedAnalysisValueAction
     */
    public function setAnalysisTypeIdentifierType($AnalysisTypeIdentifierType)
    {
      $this->AnalysisTypeIdentifierType = $AnalysisTypeIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getAnalysisValueIdentifier()
    {
      return $this->AnalysisValueIdentifier;
    }

    /**
     * @param string $AnalysisValueIdentifier
     * @return \Eurostop\Products\SubmittedAnalysisValueAction
     */
    public function setAnalysisValueIdentifier($AnalysisValueIdentifier)
    {
      $this->AnalysisValueIdentifier = $AnalysisValueIdentifier;
      return $this;
    }

    /**
     * @return AnalysisValueIdentifierType
     */
    public function getAnalysisValueIdentifierType()
    {
      return $this->AnalysisValueIdentifierType;
    }

    /**
     * @param AnalysisValueIdentifierType $AnalysisValueIdentifierType
     * @return \Eurostop\Products\SubmittedAnalysisValueAction
     */
    public function setAnalysisValueIdentifierType($AnalysisValueIdentifierType)
    {
      $this->AnalysisValueIdentifierType = $AnalysisValueIdentifierType;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getAppliesToProducts()
    {
      return $this->AppliesToProducts;
    }

    /**
     * @param boolean $AppliesToProducts
     * @return \Eurostop\Products\SubmittedAnalysisValueAction
     */
    public function setAppliesToProducts($AppliesToProducts)
    {
      $this->AppliesToProducts = $AppliesToProducts;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getAppliesToSkus()
    {
      return $this->AppliesToSkus;
    }

    /**
     * @param boolean $AppliesToSkus
     * @return \Eurostop\Products\SubmittedAnalysisValueAction
     */
    public function setAppliesToSkus($AppliesToSkus)
    {
      $this->AppliesToSkus = $AppliesToSkus;
      return $this;
    }

}
