<?php

namespace Eurostop\Products;

class SubmittedAnalysisValue extends SubmittedDataItemOfSubmittedAnalysisValueDtoVNxenGD6
{

    /**
     * @var string $AnalysisTypeIdentifier
     */
    protected $AnalysisTypeIdentifier = null;

    /**
     * @var AnalysisTypeIdentifierType $AnalysisTypeIdentifierType
     */
    protected $AnalysisTypeIdentifierType = null;

    /**
     * @var string $AnalysisValueIdentifier
     */
    protected $AnalysisValueIdentifier = null;

    /**
     * @var AnalysisValueIdentifierType $AnalysisValueIdentifierType
     */
    protected $AnalysisValueIdentifierType = null;

    /**
     * @var boolean $AppliesToProducts
     */
    protected $AppliesToProducts = null;

    /**
     * @var boolean $AppliesToSkus
     */
    protected $AppliesToSkus = null;

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var string $ShortDescription
     */
    protected $ShortDescription = null;

    /**
     * @param boolean $AppliesToProducts
     * @param boolean $AppliesToSkus
     */
    public function __construct($AppliesToProducts, $AppliesToSkus)
    {
      parent::__construct();
      $this->AppliesToProducts = $AppliesToProducts;
      $this->AppliesToSkus = $AppliesToSkus;
    }

    /**
     * @return string
     */
    public function getAnalysisTypeIdentifier()
    {
      return $this->AnalysisTypeIdentifier;
    }

    /**
     * @param string $AnalysisTypeIdentifier
     * @return \Eurostop\Products\SubmittedAnalysisValue
     */
    public function setAnalysisTypeIdentifier($AnalysisTypeIdentifier)
    {
      $this->AnalysisTypeIdentifier = $AnalysisTypeIdentifier;
      return $this;
    }

    /**
     * @return AnalysisTypeIdentifierType
     */
    public function getAnalysisTypeIdentifierType()
    {
      return $this->AnalysisTypeIdentifierType;
    }

    /**
     * @param AnalysisTypeIdentifierType $AnalysisTypeIdentifierType
     * @return \Eurostop\Products\SubmittedAnalysisValue
     */
    public function setAnalysisTypeIdentifierType($AnalysisTypeIdentifierType)
    {
      $this->AnalysisTypeIdentifierType = $AnalysisTypeIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getAnalysisValueIdentifier()
    {
      return $this->AnalysisValueIdentifier;
    }

    /**
     * @param string $AnalysisValueIdentifier
     * @return \Eurostop\Products\SubmittedAnalysisValue
     */
    public function setAnalysisValueIdentifier($AnalysisValueIdentifier)
    {
      $this->AnalysisValueIdentifier = $AnalysisValueIdentifier;
      return $this;
    }

    /**
     * @return AnalysisValueIdentifierType
     */
    public function getAnalysisValueIdentifierType()
    {
      return $this->AnalysisValueIdentifierType;
    }

    /**
     * @param AnalysisValueIdentifierType $AnalysisValueIdentifierType
     * @return \Eurostop\Products\SubmittedAnalysisValue
     */
    public function setAnalysisValueIdentifierType($AnalysisValueIdentifierType)
    {
      $this->AnalysisValueIdentifierType = $AnalysisValueIdentifierType;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getAppliesToProducts()
    {
      return $this->AppliesToProducts;
    }

    /**
     * @param boolean $AppliesToProducts
     * @return \Eurostop\Products\SubmittedAnalysisValue
     */
    public function setAppliesToProducts($AppliesToProducts)
    {
      $this->AppliesToProducts = $AppliesToProducts;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getAppliesToSkus()
    {
      return $this->AppliesToSkus;
    }

    /**
     * @param boolean $AppliesToSkus
     * @return \Eurostop\Products\SubmittedAnalysisValue
     */
    public function setAppliesToSkus($AppliesToSkus)
    {
      $this->AppliesToSkus = $AppliesToSkus;
      return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Eurostop\Products\SubmittedAnalysisValue
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return string
     */
    public function getShortDescription()
    {
      return $this->ShortDescription;
    }

    /**
     * @param string $ShortDescription
     * @return \Eurostop\Products\SubmittedAnalysisValue
     */
    public function setShortDescription($ShortDescription)
    {
      $this->ShortDescription = $ShortDescription;
      return $this;
    }

}
