<?php

namespace Eurostop\Products;

class SubmitSkuAction
{

    /**
     * @var SubmittedSkuAction $skuAction
     */
    protected $skuAction = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedSkuAction $skuAction
     * @param string $submissionReference
     */
    public function __construct($skuAction, $submissionReference)
    {
      $this->skuAction = $skuAction;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedSkuAction
     */
    public function getSkuAction()
    {
      return $this->skuAction;
    }

    /**
     * @param SubmittedSkuAction $skuAction
     * @return \Eurostop\Products\SubmitSkuAction
     */
    public function setSkuAction($skuAction)
    {
      $this->skuAction = $skuAction;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitSkuAction
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
