<?php

namespace Eurostop\Products;

class SubmitHierarchyNodeActions
{

    /**
     * @var ArrayOfSubmittedHierarchyNodeAction $hierarchyNodeActions
     */
    protected $hierarchyNodeActions = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedHierarchyNodeAction $hierarchyNodeActions
     * @param string $submissionReference
     */
    public function __construct($hierarchyNodeActions, $submissionReference)
    {
      $this->hierarchyNodeActions = $hierarchyNodeActions;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedHierarchyNodeAction
     */
    public function getHierarchyNodeActions()
    {
      return $this->hierarchyNodeActions;
    }

    /**
     * @param ArrayOfSubmittedHierarchyNodeAction $hierarchyNodeActions
     * @return \Eurostop\Products\SubmitHierarchyNodeActions
     */
    public function setHierarchyNodeActions($hierarchyNodeActions)
    {
      $this->hierarchyNodeActions = $hierarchyNodeActions;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitHierarchyNodeActions
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
