<?php

namespace Eurostop\Products;

class SubmitBranchSkuTaxes
{

    /**
     * @var ArrayOfSubmittedBranchSkuTax $branchSkuTaxes
     */
    protected $branchSkuTaxes = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedBranchSkuTax $branchSkuTaxes
     * @param string $submissionReference
     */
    public function __construct($branchSkuTaxes, $submissionReference)
    {
      $this->branchSkuTaxes = $branchSkuTaxes;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedBranchSkuTax
     */
    public function getBranchSkuTaxes()
    {
      return $this->branchSkuTaxes;
    }

    /**
     * @param ArrayOfSubmittedBranchSkuTax $branchSkuTaxes
     * @return \Eurostop\Products\SubmitBranchSkuTaxes
     */
    public function setBranchSkuTaxes($branchSkuTaxes)
    {
      $this->branchSkuTaxes = $branchSkuTaxes;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitBranchSkuTaxes
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
