<?php

namespace Eurostop\Products;

class SubmitAnalysisValueActions
{

    /**
     * @var ArrayOfSubmittedAnalysisValueAction $analysisValueActions
     */
    protected $analysisValueActions = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedAnalysisValueAction $analysisValueActions
     * @param string $submissionReference
     */
    public function __construct($analysisValueActions, $submissionReference)
    {
      $this->analysisValueActions = $analysisValueActions;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedAnalysisValueAction
     */
    public function getAnalysisValueActions()
    {
      return $this->analysisValueActions;
    }

    /**
     * @param ArrayOfSubmittedAnalysisValueAction $analysisValueActions
     * @return \Eurostop\Products\SubmitAnalysisValueActions
     */
    public function setAnalysisValueActions($analysisValueActions)
    {
      $this->analysisValueActions = $analysisValueActions;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitAnalysisValueActions
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
