<?php

namespace Eurostop\Products;

class Sku extends CodedRetrievedDataItemOfSkuDtoVNxenGD6
{

    /**
     * @var ArrayOfAnalysisValue $AnalysisValues
     */
    protected $AnalysisValues = null;

    /**
     * @var AvailabilityType $Availability
     */
    protected $Availability = null;

    /**
     * @var string $ColourIdentifier
     */
    protected $ColourIdentifier = null;

    /**
     * @var \DateTime $CreatedDate
     */
    protected $CreatedDate = null;

    /**
     * @var float $CurrentCostPrice
     */
    protected $CurrentCostPrice = null;

    /**
     * @var float $CurrentRecommendedPrice
     */
    protected $CurrentRecommendedPrice = null;

    /**
     * @var float $CurrentSellingPrice
     */
    protected $CurrentSellingPrice = null;

    /**
     * @var string $EanCode
     */
    protected $EanCode = null;

    /**
     * @var string $ExistCode
     */
    protected $ExistCode = null;

    /**
     * @var float $FranchiseSellingPrice
     */
    protected $FranchiseSellingPrice = null;

    /**
     * @var boolean $IsStaffDiscountable
     */
    protected $IsStaffDiscountable = null;

    /**
     * @var LifecycleStatusType $LifecycleStatus
     */
    protected $LifecycleStatus = null;

    /**
     * @var \DateTime $ModifiedDate
     */
    protected $ModifiedDate = null;

    /**
     * @var float $OriginalRecommendedPrice
     */
    protected $OriginalRecommendedPrice = null;

    /**
     * @var float $OriginalSellingPrice
     */
    protected $OriginalSellingPrice = null;

    /**
     * @var string $PosCode
     */
    protected $PosCode = null;

    /**
     * @var string $ProductIdentifier
     */
    protected $ProductIdentifier = null;

    /**
     * @var string $SizeIdentifier
     */
    protected $SizeIdentifier = null;

    /**
     * @var string $VatRateIdentifier
     */
    protected $VatRateIdentifier = null;

    /**
     * @var float $WholeSaleSellingPrice
     */
    protected $WholeSaleSellingPrice = null;

    /**
     * @param AvailabilityType $Availability
     * @param \DateTime $CreatedDate
     * @param float $CurrentCostPrice
     * @param float $CurrentRecommendedPrice
     * @param float $CurrentSellingPrice
     * @param float $FranchiseSellingPrice
     * @param boolean $IsStaffDiscountable
     * @param LifecycleStatusType $LifecycleStatus
     * @param \DateTime $ModifiedDate
     * @param float $OriginalRecommendedPrice
     * @param float $OriginalSellingPrice
     * @param float $WholeSaleSellingPrice
     */
    public function __construct($Availability, \DateTime $CreatedDate, $CurrentCostPrice, $CurrentRecommendedPrice, $CurrentSellingPrice, $FranchiseSellingPrice, $IsStaffDiscountable, $LifecycleStatus, \DateTime $ModifiedDate, $OriginalRecommendedPrice, $OriginalSellingPrice, $WholeSaleSellingPrice)
    {
      parent::__construct();
      $this->Availability = $Availability;
      $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
      $this->CurrentCostPrice = $CurrentCostPrice;
      $this->CurrentRecommendedPrice = $CurrentRecommendedPrice;
      $this->CurrentSellingPrice = $CurrentSellingPrice;
      $this->FranchiseSellingPrice = $FranchiseSellingPrice;
      $this->IsStaffDiscountable = $IsStaffDiscountable;
      $this->LifecycleStatus = $LifecycleStatus;
      $this->ModifiedDate = $ModifiedDate->format(\DateTime::ATOM);
      $this->OriginalRecommendedPrice = $OriginalRecommendedPrice;
      $this->OriginalSellingPrice = $OriginalSellingPrice;
      $this->WholeSaleSellingPrice = $WholeSaleSellingPrice;
    }

    /**
     * @return ArrayOfAnalysisValue
     */
    public function getAnalysisValues()
    {
      return $this->AnalysisValues;
    }

    /**
     * @param ArrayOfAnalysisValue $AnalysisValues
     * @return \Eurostop\Products\Sku
     */
    public function setAnalysisValues($AnalysisValues)
    {
      $this->AnalysisValues = $AnalysisValues;
      return $this;
    }

    /**
     * @return AvailabilityType
     */
    public function getAvailability()
    {
      return $this->Availability;
    }

    /**
     * @param AvailabilityType $Availability
     * @return \Eurostop\Products\Sku
     */
    public function setAvailability($Availability)
    {
      $this->Availability = $Availability;
      return $this;
    }

    /**
     * @return string
     */
    public function getColourIdentifier()
    {
      return $this->ColourIdentifier;
    }

    /**
     * @param string $ColourIdentifier
     * @return \Eurostop\Products\Sku
     */
    public function setColourIdentifier($ColourIdentifier)
    {
      $this->ColourIdentifier = $ColourIdentifier;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedDate()
    {
      if ($this->CreatedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CreatedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CreatedDate
     * @return \Eurostop\Products\Sku
     */
    public function setCreatedDate(\DateTime $CreatedDate)
    {
      $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return float
     */
    public function getCurrentCostPrice()
    {
      return $this->CurrentCostPrice;
    }

    /**
     * @param float $CurrentCostPrice
     * @return \Eurostop\Products\Sku
     */
    public function setCurrentCostPrice($CurrentCostPrice)
    {
      $this->CurrentCostPrice = $CurrentCostPrice;
      return $this;
    }

    /**
     * @return float
     */
    public function getCurrentRecommendedPrice()
    {
      return $this->CurrentRecommendedPrice;
    }

    /**
     * @param float $CurrentRecommendedPrice
     * @return \Eurostop\Products\Sku
     */
    public function setCurrentRecommendedPrice($CurrentRecommendedPrice)
    {
      $this->CurrentRecommendedPrice = $CurrentRecommendedPrice;
      return $this;
    }

    /**
     * @return float
     */
    public function getCurrentSellingPrice()
    {
      return $this->CurrentSellingPrice;
    }

    /**
     * @param float $CurrentSellingPrice
     * @return \Eurostop\Products\Sku
     */
    public function setCurrentSellingPrice($CurrentSellingPrice)
    {
      $this->CurrentSellingPrice = $CurrentSellingPrice;
      return $this;
    }

    /**
     * @return string
     */
    public function getEanCode()
    {
      return $this->EanCode;
    }

    /**
     * @param string $EanCode
     * @return \Eurostop\Products\Sku
     */
    public function setEanCode($EanCode)
    {
      $this->EanCode = $EanCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getExistCode()
    {
      return $this->ExistCode;
    }

    /**
     * @param string $ExistCode
     * @return \Eurostop\Products\Sku
     */
    public function setExistCode($ExistCode)
    {
      $this->ExistCode = $ExistCode;
      return $this;
    }

    /**
     * @return float
     */
    public function getFranchiseSellingPrice()
    {
      return $this->FranchiseSellingPrice;
    }

    /**
     * @param float $FranchiseSellingPrice
     * @return \Eurostop\Products\Sku
     */
    public function setFranchiseSellingPrice($FranchiseSellingPrice)
    {
      $this->FranchiseSellingPrice = $FranchiseSellingPrice;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsStaffDiscountable()
    {
      return $this->IsStaffDiscountable;
    }

    /**
     * @param boolean $IsStaffDiscountable
     * @return \Eurostop\Products\Sku
     */
    public function setIsStaffDiscountable($IsStaffDiscountable)
    {
      $this->IsStaffDiscountable = $IsStaffDiscountable;
      return $this;
    }

    /**
     * @return LifecycleStatusType
     */
    public function getLifecycleStatus()
    {
      return $this->LifecycleStatus;
    }

    /**
     * @param LifecycleStatusType $LifecycleStatus
     * @return \Eurostop\Products\Sku
     */
    public function setLifecycleStatus($LifecycleStatus)
    {
      $this->LifecycleStatus = $LifecycleStatus;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedDate()
    {
      if ($this->ModifiedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ModifiedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ModifiedDate
     * @return \Eurostop\Products\Sku
     */
    public function setModifiedDate(\DateTime $ModifiedDate)
    {
      $this->ModifiedDate = $ModifiedDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return float
     */
    public function getOriginalRecommendedPrice()
    {
      return $this->OriginalRecommendedPrice;
    }

    /**
     * @param float $OriginalRecommendedPrice
     * @return \Eurostop\Products\Sku
     */
    public function setOriginalRecommendedPrice($OriginalRecommendedPrice)
    {
      $this->OriginalRecommendedPrice = $OriginalRecommendedPrice;
      return $this;
    }

    /**
     * @return float
     */
    public function getOriginalSellingPrice()
    {
      return $this->OriginalSellingPrice;
    }

    /**
     * @param float $OriginalSellingPrice
     * @return \Eurostop\Products\Sku
     */
    public function setOriginalSellingPrice($OriginalSellingPrice)
    {
      $this->OriginalSellingPrice = $OriginalSellingPrice;
      return $this;
    }

    /**
     * @return string
     */
    public function getPosCode()
    {
      return $this->PosCode;
    }

    /**
     * @param string $PosCode
     * @return \Eurostop\Products\Sku
     */
    public function setPosCode($PosCode)
    {
      $this->PosCode = $PosCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getProductIdentifier()
    {
      return $this->ProductIdentifier;
    }

    /**
     * @param string $ProductIdentifier
     * @return \Eurostop\Products\Sku
     */
    public function setProductIdentifier($ProductIdentifier)
    {
      $this->ProductIdentifier = $ProductIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getSizeIdentifier()
    {
      return $this->SizeIdentifier;
    }

    /**
     * @param string $SizeIdentifier
     * @return \Eurostop\Products\Sku
     */
    public function setSizeIdentifier($SizeIdentifier)
    {
      $this->SizeIdentifier = $SizeIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getVatRateIdentifier()
    {
      return $this->VatRateIdentifier;
    }

    /**
     * @param string $VatRateIdentifier
     * @return \Eurostop\Products\Sku
     */
    public function setVatRateIdentifier($VatRateIdentifier)
    {
      $this->VatRateIdentifier = $VatRateIdentifier;
      return $this;
    }

    /**
     * @return float
     */
    public function getWholeSaleSellingPrice()
    {
      return $this->WholeSaleSellingPrice;
    }

    /**
     * @param float $WholeSaleSellingPrice
     * @return \Eurostop\Products\Sku
     */
    public function setWholeSaleSellingPrice($WholeSaleSellingPrice)
    {
      $this->WholeSaleSellingPrice = $WholeSaleSellingPrice;
      return $this;
    }

}
