<?php

namespace Eurostop\Products;

class GetSkuPricesByCountry
{

    /**
     * @var string $countryIdentifier
     */
    protected $countryIdentifier = null;

    /**
     * @var CountryIdentifierType $countryIdentifierType
     */
    protected $countryIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @var int $maxPrices
     */
    protected $maxPrices = null;

    /**
     * @param string $countryIdentifier
     * @param CountryIdentifierType $countryIdentifierType
     * @param \DateTime $modifiedSinceDate
     * @param int $maxPrices
     */
    public function __construct($countryIdentifier, $countryIdentifierType, \DateTime $modifiedSinceDate, $maxPrices)
    {
      $this->countryIdentifier = $countryIdentifier;
      $this->countryIdentifierType = $countryIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      $this->maxPrices = $maxPrices;
    }

    /**
     * @return string
     */
    public function getCountryIdentifier()
    {
      return $this->countryIdentifier;
    }

    /**
     * @param string $countryIdentifier
     * @return \Eurostop\Products\GetSkuPricesByCountry
     */
    public function setCountryIdentifier($countryIdentifier)
    {
      $this->countryIdentifier = $countryIdentifier;
      return $this;
    }

    /**
     * @return CountryIdentifierType
     */
    public function getCountryIdentifierType()
    {
      return $this->countryIdentifierType;
    }

    /**
     * @param CountryIdentifierType $countryIdentifierType
     * @return \Eurostop\Products\GetSkuPricesByCountry
     */
    public function setCountryIdentifierType($countryIdentifierType)
    {
      $this->countryIdentifierType = $countryIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Products\GetSkuPricesByCountry
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return int
     */
    public function getMaxPrices()
    {
      return $this->maxPrices;
    }

    /**
     * @param int $maxPrices
     * @return \Eurostop\Products\GetSkuPricesByCountry
     */
    public function setMaxPrices($maxPrices)
    {
      $this->maxPrices = $maxPrices;
      return $this;
    }

}
