<?php

namespace Eurostop\Products;

class GetSkuAnalysisValue
{

    /**
     * @var string $analysisTypeIdentifier
     */
    protected $analysisTypeIdentifier = null;

    /**
     * @var AnalysisTypeIdentifierType $analysisTypeIdentifierType
     */
    protected $analysisTypeIdentifierType = null;

    /**
     * @var string $analysisValueIdentifier
     */
    protected $analysisValueIdentifier = null;

    /**
     * @var AnalysisValueIdentifierType $analysisValueIdentifierType
     */
    protected $analysisValueIdentifierType = null;

    /**
     * @param string $analysisTypeIdentifier
     * @param AnalysisTypeIdentifierType $analysisTypeIdentifierType
     * @param string $analysisValueIdentifier
     * @param AnalysisValueIdentifierType $analysisValueIdentifierType
     */
    public function __construct($analysisTypeIdentifier, $analysisTypeIdentifierType, $analysisValueIdentifier, $analysisValueIdentifierType)
    {
      $this->analysisTypeIdentifier = $analysisTypeIdentifier;
      $this->analysisTypeIdentifierType = $analysisTypeIdentifierType;
      $this->analysisValueIdentifier = $analysisValueIdentifier;
      $this->analysisValueIdentifierType = $analysisValueIdentifierType;
    }

    /**
     * @return string
     */
    public function getAnalysisTypeIdentifier()
    {
      return $this->analysisTypeIdentifier;
    }

    /**
     * @param string $analysisTypeIdentifier
     * @return \Eurostop\Products\GetSkuAnalysisValue
     */
    public function setAnalysisTypeIdentifier($analysisTypeIdentifier)
    {
      $this->analysisTypeIdentifier = $analysisTypeIdentifier;
      return $this;
    }

    /**
     * @return AnalysisTypeIdentifierType
     */
    public function getAnalysisTypeIdentifierType()
    {
      return $this->analysisTypeIdentifierType;
    }

    /**
     * @param AnalysisTypeIdentifierType $analysisTypeIdentifierType
     * @return \Eurostop\Products\GetSkuAnalysisValue
     */
    public function setAnalysisTypeIdentifierType($analysisTypeIdentifierType)
    {
      $this->analysisTypeIdentifierType = $analysisTypeIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getAnalysisValueIdentifier()
    {
      return $this->analysisValueIdentifier;
    }

    /**
     * @param string $analysisValueIdentifier
     * @return \Eurostop\Products\GetSkuAnalysisValue
     */
    public function setAnalysisValueIdentifier($analysisValueIdentifier)
    {
      $this->analysisValueIdentifier = $analysisValueIdentifier;
      return $this;
    }

    /**
     * @return AnalysisValueIdentifierType
     */
    public function getAnalysisValueIdentifierType()
    {
      return $this->analysisValueIdentifierType;
    }

    /**
     * @param AnalysisValueIdentifierType $analysisValueIdentifierType
     * @return \Eurostop\Products\GetSkuAnalysisValue
     */
    public function setAnalysisValueIdentifierType($analysisValueIdentifierType)
    {
      $this->analysisValueIdentifierType = $analysisValueIdentifierType;
      return $this;
    }

}
