<?php

namespace Eurostop\Products;

class GetProductsByLevel1HierarchyNode
{

    /**
     * @var string $level1HierarchyNodeIdentifier
     */
    protected $level1HierarchyNodeIdentifier = null;

    /**
     * @var HierarchyNodeIdentifierType $hierarchyNodeIdentifierType
     */
    protected $hierarchyNodeIdentifierType = null;

    /**
     * @var boolean $returnAnalysisValues
     */
    protected $returnAnalysisValues = null;

    /**
     * @var boolean $returnExtendedAttributeValues
     */
    protected $returnExtendedAttributeValues = null;

    /**
     * @var string $cultureCode
     */
    protected $cultureCode = null;

    /**
     * @param string $level1HierarchyNodeIdentifier
     * @param HierarchyNodeIdentifierType $hierarchyNodeIdentifierType
     * @param boolean $returnAnalysisValues
     * @param boolean $returnExtendedAttributeValues
     * @param string $cultureCode
     */
    public function __construct($level1HierarchyNodeIdentifier, $hierarchyNodeIdentifierType, $returnAnalysisValues, $returnExtendedAttributeValues, $cultureCode)
    {
      $this->level1HierarchyNodeIdentifier = $level1HierarchyNodeIdentifier;
      $this->hierarchyNodeIdentifierType = $hierarchyNodeIdentifierType;
      $this->returnAnalysisValues = $returnAnalysisValues;
      $this->returnExtendedAttributeValues = $returnExtendedAttributeValues;
      $this->cultureCode = $cultureCode;
    }

    /**
     * @return string
     */
    public function getLevel1HierarchyNodeIdentifier()
    {
      return $this->level1HierarchyNodeIdentifier;
    }

    /**
     * @param string $level1HierarchyNodeIdentifier
     * @return \Eurostop\Products\GetProductsByLevel1HierarchyNode
     */
    public function setLevel1HierarchyNodeIdentifier($level1HierarchyNodeIdentifier)
    {
      $this->level1HierarchyNodeIdentifier = $level1HierarchyNodeIdentifier;
      return $this;
    }

    /**
     * @return HierarchyNodeIdentifierType
     */
    public function getHierarchyNodeIdentifierType()
    {
      return $this->hierarchyNodeIdentifierType;
    }

    /**
     * @param HierarchyNodeIdentifierType $hierarchyNodeIdentifierType
     * @return \Eurostop\Products\GetProductsByLevel1HierarchyNode
     */
    public function setHierarchyNodeIdentifierType($hierarchyNodeIdentifierType)
    {
      $this->hierarchyNodeIdentifierType = $hierarchyNodeIdentifierType;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getReturnAnalysisValues()
    {
      return $this->returnAnalysisValues;
    }

    /**
     * @param boolean $returnAnalysisValues
     * @return \Eurostop\Products\GetProductsByLevel1HierarchyNode
     */
    public function setReturnAnalysisValues($returnAnalysisValues)
    {
      $this->returnAnalysisValues = $returnAnalysisValues;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getReturnExtendedAttributeValues()
    {
      return $this->returnExtendedAttributeValues;
    }

    /**
     * @param boolean $returnExtendedAttributeValues
     * @return \Eurostop\Products\GetProductsByLevel1HierarchyNode
     */
    public function setReturnExtendedAttributeValues($returnExtendedAttributeValues)
    {
      $this->returnExtendedAttributeValues = $returnExtendedAttributeValues;
      return $this;
    }

    /**
     * @return string
     */
    public function getCultureCode()
    {
      return $this->cultureCode;
    }

    /**
     * @param string $cultureCode
     * @return \Eurostop\Products\GetProductsByLevel1HierarchyNode
     */
    public function setCultureCode($cultureCode)
    {
      $this->cultureCode = $cultureCode;
      return $this;
    }

}
