<?php

namespace Eurostop\Products;

class GetProductsByAnalysisValue
{

    /**
     * @var string $analysisTypeIdentifier
     */
    protected $analysisTypeIdentifier = null;

    /**
     * @var string $analysisValueIdentifier
     */
    protected $analysisValueIdentifier = null;

    /**
     * @var AnalysisTypeIdentifierType $analysisTypeIdentifierType
     */
    protected $analysisTypeIdentifierType = null;

    /**
     * @var AnalysisValueIdentifierType $analysisValueIdentifierType
     */
    protected $analysisValueIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @var boolean $returnAnalysisValues
     */
    protected $returnAnalysisValues = null;

    /**
     * @var boolean $returnExtendedAttributeValues
     */
    protected $returnExtendedAttributeValues = null;

    /**
     * @var string $cultureCode
     */
    protected $cultureCode = null;

    /**
     * @var \DateTime $modifiedUntilDate
     */
    protected $modifiedUntilDate = null;

    /**
     * @param string $analysisTypeIdentifier
     * @param string $analysisValueIdentifier
     * @param AnalysisTypeIdentifierType $analysisTypeIdentifierType
     * @param AnalysisValueIdentifierType $analysisValueIdentifierType
     * @param \DateTime $modifiedSinceDate
     * @param boolean $returnAnalysisValues
     * @param boolean $returnExtendedAttributeValues
     * @param string $cultureCode
     * @param \DateTime $modifiedUntilDate
     */
    public function __construct($analysisTypeIdentifier, $analysisValueIdentifier, $analysisTypeIdentifierType, $analysisValueIdentifierType, \DateTime $modifiedSinceDate, $returnAnalysisValues, $returnExtendedAttributeValues, $cultureCode, \DateTime $modifiedUntilDate)
    {
      $this->analysisTypeIdentifier = $analysisTypeIdentifier;
      $this->analysisValueIdentifier = $analysisValueIdentifier;
      $this->analysisTypeIdentifierType = $analysisTypeIdentifierType;
      $this->analysisValueIdentifierType = $analysisValueIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      $this->returnAnalysisValues = $returnAnalysisValues;
      $this->returnExtendedAttributeValues = $returnExtendedAttributeValues;
      $this->cultureCode = $cultureCode;
      $this->modifiedUntilDate = $modifiedUntilDate->format(\DateTime::ATOM);
    }

    /**
     * @return string
     */
    public function getAnalysisTypeIdentifier()
    {
      return $this->analysisTypeIdentifier;
    }

    /**
     * @param string $analysisTypeIdentifier
     * @return \Eurostop\Products\GetProductsByAnalysisValue
     */
    public function setAnalysisTypeIdentifier($analysisTypeIdentifier)
    {
      $this->analysisTypeIdentifier = $analysisTypeIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getAnalysisValueIdentifier()
    {
      return $this->analysisValueIdentifier;
    }

    /**
     * @param string $analysisValueIdentifier
     * @return \Eurostop\Products\GetProductsByAnalysisValue
     */
    public function setAnalysisValueIdentifier($analysisValueIdentifier)
    {
      $this->analysisValueIdentifier = $analysisValueIdentifier;
      return $this;
    }

    /**
     * @return AnalysisTypeIdentifierType
     */
    public function getAnalysisTypeIdentifierType()
    {
      return $this->analysisTypeIdentifierType;
    }

    /**
     * @param AnalysisTypeIdentifierType $analysisTypeIdentifierType
     * @return \Eurostop\Products\GetProductsByAnalysisValue
     */
    public function setAnalysisTypeIdentifierType($analysisTypeIdentifierType)
    {
      $this->analysisTypeIdentifierType = $analysisTypeIdentifierType;
      return $this;
    }

    /**
     * @return AnalysisValueIdentifierType
     */
    public function getAnalysisValueIdentifierType()
    {
      return $this->analysisValueIdentifierType;
    }

    /**
     * @param AnalysisValueIdentifierType $analysisValueIdentifierType
     * @return \Eurostop\Products\GetProductsByAnalysisValue
     */
    public function setAnalysisValueIdentifierType($analysisValueIdentifierType)
    {
      $this->analysisValueIdentifierType = $analysisValueIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Products\GetProductsByAnalysisValue
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getReturnAnalysisValues()
    {
      return $this->returnAnalysisValues;
    }

    /**
     * @param boolean $returnAnalysisValues
     * @return \Eurostop\Products\GetProductsByAnalysisValue
     */
    public function setReturnAnalysisValues($returnAnalysisValues)
    {
      $this->returnAnalysisValues = $returnAnalysisValues;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getReturnExtendedAttributeValues()
    {
      return $this->returnExtendedAttributeValues;
    }

    /**
     * @param boolean $returnExtendedAttributeValues
     * @return \Eurostop\Products\GetProductsByAnalysisValue
     */
    public function setReturnExtendedAttributeValues($returnExtendedAttributeValues)
    {
      $this->returnExtendedAttributeValues = $returnExtendedAttributeValues;
      return $this;
    }

    /**
     * @return string
     */
    public function getCultureCode()
    {
      return $this->cultureCode;
    }

    /**
     * @param string $cultureCode
     * @return \Eurostop\Products\GetProductsByAnalysisValue
     */
    public function setCultureCode($cultureCode)
    {
      $this->cultureCode = $cultureCode;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedUntilDate()
    {
      if ($this->modifiedUntilDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedUntilDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedUntilDate
     * @return \Eurostop\Products\GetProductsByAnalysisValue
     */
    public function setModifiedUntilDate(\DateTime $modifiedUntilDate)
    {
      $this->modifiedUntilDate = $modifiedUntilDate->format(\DateTime::ATOM);
      return $this;
    }

}
