<?php

namespace Eurostop\Products;

class GetProductAnalysisValuesByType
{

    /**
     * @var string $analysisTypeIdentifier
     */
    protected $analysisTypeIdentifier = null;

    /**
     * @var AnalysisTypeIdentifierType $analysisTypeIdentifierType
     */
    protected $analysisTypeIdentifierType = null;

    /**
     * @param string $analysisTypeIdentifier
     * @param AnalysisTypeIdentifierType $analysisTypeIdentifierType
     */
    public function __construct($analysisTypeIdentifier, $analysisTypeIdentifierType)
    {
      $this->analysisTypeIdentifier = $analysisTypeIdentifier;
      $this->analysisTypeIdentifierType = $analysisTypeIdentifierType;
    }

    /**
     * @return string
     */
    public function getAnalysisTypeIdentifier()
    {
      return $this->analysisTypeIdentifier;
    }

    /**
     * @param string $analysisTypeIdentifier
     * @return \Eurostop\Products\GetProductAnalysisValuesByType
     */
    public function setAnalysisTypeIdentifier($analysisTypeIdentifier)
    {
      $this->analysisTypeIdentifier = $analysisTypeIdentifier;
      return $this;
    }

    /**
     * @return AnalysisTypeIdentifierType
     */
    public function getAnalysisTypeIdentifierType()
    {
      return $this->analysisTypeIdentifierType;
    }

    /**
     * @param AnalysisTypeIdentifierType $analysisTypeIdentifierType
     * @return \Eurostop\Products\GetProductAnalysisValuesByType
     */
    public function setAnalysisTypeIdentifierType($analysisTypeIdentifierType)
    {
      $this->analysisTypeIdentifierType = $analysisTypeIdentifierType;
      return $this;
    }

}
