<?php

namespace Eurostop\Products;

class GetProduct
{

    /**
     * @var string $productIdentifier
     */
    protected $productIdentifier = null;

    /**
     * @var ProductIdentifierType $productIdentifierType
     */
    protected $productIdentifierType = null;

    /**
     * @var boolean $returnAnalysisValues
     */
    protected $returnAnalysisValues = null;

    /**
     * @var boolean $returnExtendedAttributeValues
     */
    protected $returnExtendedAttributeValues = null;

    /**
     * @var string $cultureCode
     */
    protected $cultureCode = null;

    /**
     * @param string $productIdentifier
     * @param ProductIdentifierType $productIdentifierType
     * @param boolean $returnAnalysisValues
     * @param boolean $returnExtendedAttributeValues
     * @param string $cultureCode
     */
    public function __construct($productIdentifier, $productIdentifierType, $returnAnalysisValues, $returnExtendedAttributeValues, $cultureCode)
    {
      $this->productIdentifier = $productIdentifier;
      $this->productIdentifierType = $productIdentifierType;
      $this->returnAnalysisValues = $returnAnalysisValues;
      $this->returnExtendedAttributeValues = $returnExtendedAttributeValues;
      $this->cultureCode = $cultureCode;
    }

    /**
     * @return string
     */
    public function getProductIdentifier()
    {
      return $this->productIdentifier;
    }

    /**
     * @param string $productIdentifier
     * @return \Eurostop\Products\GetProduct
     */
    public function setProductIdentifier($productIdentifier)
    {
      $this->productIdentifier = $productIdentifier;
      return $this;
    }

    /**
     * @return ProductIdentifierType
     */
    public function getProductIdentifierType()
    {
      return $this->productIdentifierType;
    }

    /**
     * @param ProductIdentifierType $productIdentifierType
     * @return \Eurostop\Products\GetProduct
     */
    public function setProductIdentifierType($productIdentifierType)
    {
      $this->productIdentifierType = $productIdentifierType;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getReturnAnalysisValues()
    {
      return $this->returnAnalysisValues;
    }

    /**
     * @param boolean $returnAnalysisValues
     * @return \Eurostop\Products\GetProduct
     */
    public function setReturnAnalysisValues($returnAnalysisValues)
    {
      $this->returnAnalysisValues = $returnAnalysisValues;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getReturnExtendedAttributeValues()
    {
      return $this->returnExtendedAttributeValues;
    }

    /**
     * @param boolean $returnExtendedAttributeValues
     * @return \Eurostop\Products\GetProduct
     */
    public function setReturnExtendedAttributeValues($returnExtendedAttributeValues)
    {
      $this->returnExtendedAttributeValues = $returnExtendedAttributeValues;
      return $this;
    }

    /**
     * @return string
     */
    public function getCultureCode()
    {
      return $this->cultureCode;
    }

    /**
     * @param string $cultureCode
     * @return \Eurostop\Products\GetProduct
     */
    public function setCultureCode($cultureCode)
    {
      $this->cultureCode = $cultureCode;
      return $this;
    }

}
