<?php

namespace Eurostop\Products;

class ArrayOfSizeGroup implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var SizeGroup[] $SizeGroup
     */
    protected $SizeGroup = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return SizeGroup[]
     */
    public function getSizeGroup()
    {
      return $this->SizeGroup;
    }

    /**
     * @param SizeGroup[] $SizeGroup
     * @return \Eurostop\Products\ArrayOfSizeGroup
     */
    public function setSizeGroup(array $SizeGroup = null)
    {
      $this->SizeGroup = $SizeGroup;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->SizeGroup[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return SizeGroup
     */
    public function offsetGet($offset)
    {
      return $this->SizeGroup[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param SizeGroup $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->SizeGroup[] = $value;
      } else {
        $this->SizeGroup[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->SizeGroup[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return SizeGroup Return the current element
     */
    public function current()
    {
      return current($this->SizeGroup);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->SizeGroup);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->SizeGroup);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->SizeGroup);
    }

    /**
     * Countable implementation
     *
     * @return SizeGroup Return count of elements
     */
    public function count()
    {
      return count($this->SizeGroup);
    }

}
