<?php

namespace Eurostop\Organisation;

class TaxRate extends RetrievedDataItemOfTaxRateDtoTPKTiFnX
{

    /**
     * @var string $RateCode
     */
    protected $RateCode = null;

    /**
     * @var string $RateName
     */
    protected $RateName = null;

    /**
     * @var float $PercentageRate
     */
    protected $PercentageRate = null;

    /**
     * @var DateTimeOffset $EffectiveFromDate
     */
    protected $EffectiveFromDate = null;

    /**
     * @var DateTimeOffset $EffectiveToDate
     */
    protected $EffectiveToDate = null;

    /**
     * @var string $RuleCode
     */
    protected $RuleCode = null;

    /**
     * @var string $RuleName
     */
    protected $RuleName = null;

    /**
     * @var string $TaxAuthorityIdentifier
     */
    protected $TaxAuthorityIdentifier = null;

    /**
     * @param float $PercentageRate
     * @param DateTimeOffset $EffectiveFromDate
     */
    public function __construct($PercentageRate, $EffectiveFromDate)
    {
      parent::__construct();
      $this->PercentageRate = $PercentageRate;
      $this->EffectiveFromDate = $EffectiveFromDate;
    }

    /**
     * @return string
     */
    public function getRateCode()
    {
      return $this->RateCode;
    }

    /**
     * @param string $RateCode
     * @return \Eurostop\Organisation\TaxRate
     */
    public function setRateCode($RateCode)
    {
      $this->RateCode = $RateCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getRateName()
    {
      return $this->RateName;
    }

    /**
     * @param string $RateName
     * @return \Eurostop\Organisation\TaxRate
     */
    public function setRateName($RateName)
    {
      $this->RateName = $RateName;
      return $this;
    }

    /**
     * @return float
     */
    public function getPercentageRate()
    {
      return $this->PercentageRate;
    }

    /**
     * @param float $PercentageRate
     * @return \Eurostop\Organisation\TaxRate
     */
    public function setPercentageRate($PercentageRate)
    {
      $this->PercentageRate = $PercentageRate;
      return $this;
    }

    /**
     * @return DateTimeOffset
     */
    public function getEffectiveFromDate()
    {
      return $this->EffectiveFromDate;
    }

    /**
     * @param DateTimeOffset $EffectiveFromDate
     * @return \Eurostop\Organisation\TaxRate
     */
    public function setEffectiveFromDate($EffectiveFromDate)
    {
      $this->EffectiveFromDate = $EffectiveFromDate;
      return $this;
    }

    /**
     * @return DateTimeOffset
     */
    public function getEffectiveToDate()
    {
      return $this->EffectiveToDate;
    }

    /**
     * @param DateTimeOffset $EffectiveToDate
     * @return \Eurostop\Organisation\TaxRate
     */
    public function setEffectiveToDate($EffectiveToDate)
    {
      $this->EffectiveToDate = $EffectiveToDate;
      return $this;
    }

    /**
     * @return string
     */
    public function getRuleCode()
    {
      return $this->RuleCode;
    }

    /**
     * @param string $RuleCode
     * @return \Eurostop\Organisation\TaxRate
     */
    public function setRuleCode($RuleCode)
    {
      $this->RuleCode = $RuleCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getRuleName()
    {
      return $this->RuleName;
    }

    /**
     * @param string $RuleName
     * @return \Eurostop\Organisation\TaxRate
     */
    public function setRuleName($RuleName)
    {
      $this->RuleName = $RuleName;
      return $this;
    }

    /**
     * @return string
     */
    public function getTaxAuthorityIdentifier()
    {
      return $this->TaxAuthorityIdentifier;
    }

    /**
     * @param string $TaxAuthorityIdentifier
     * @return \Eurostop\Organisation\TaxRate
     */
    public function setTaxAuthorityIdentifier($TaxAuthorityIdentifier)
    {
      $this->TaxAuthorityIdentifier = $TaxAuthorityIdentifier;
      return $this;
    }

}
