<?php

namespace Eurostop\Organisation;

class SubmitVatRate
{

    /**
     * @var SubmittedVatRate $vatRate
     */
    protected $vatRate = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedVatRate $vatRate
     * @param string $submissionReference
     */
    public function __construct($vatRate, $submissionReference)
    {
      $this->vatRate = $vatRate;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedVatRate
     */
    public function getVatRate()
    {
      return $this->vatRate;
    }

    /**
     * @param SubmittedVatRate $vatRate
     * @return \Eurostop\Organisation\SubmitVatRate
     */
    public function setVatRate($vatRate)
    {
      $this->vatRate = $vatRate;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Organisation\SubmitVatRate
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
