<?php

namespace Eurostop\Organisation;

class SubmitTenderType
{

    /**
     * @var SubmittedTenderType $tenderType
     */
    protected $tenderType = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedTenderType $tenderType
     * @param string $submissionReference
     */
    public function __construct($tenderType, $submissionReference)
    {
      $this->tenderType = $tenderType;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedTenderType
     */
    public function getTenderType()
    {
      return $this->tenderType;
    }

    /**
     * @param SubmittedTenderType $tenderType
     * @return \Eurostop\Organisation\SubmitTenderType
     */
    public function setTenderType($tenderType)
    {
      $this->tenderType = $tenderType;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Organisation\SubmitTenderType
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
