<?php

namespace Eurostop\Organisation;

class ArrayOfBranch implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var Branch[] $Branch
     */
    protected $Branch = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return Branch[]
     */
    public function getBranch()
    {
      return $this->Branch;
    }

    /**
     * @param Branch[] $Branch
     * @return \Eurostop\Organisation\ArrayOfBranch
     */
    public function setBranch(array $Branch = null)
    {
      $this->Branch = $Branch;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->Branch[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return Branch
     */
    public function offsetGet($offset)
    {
      return $this->Branch[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param Branch $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->Branch[] = $value;
      } else {
        $this->Branch[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->Branch[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return Branch Return the current element
     */
    public function current()
    {
      return current($this->Branch);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->Branch);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->Branch);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->Branch);
    }

    /**
     * Countable implementation
     *
     * @return Branch Return count of elements
     */
    public function count()
    {
      return count($this->Branch);
    }

}
