<?php

namespace Eurostop\Loyalty;

class ArrayOfCustomerAccountType implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var CustomerAccountType[] $CustomerAccountType
     */
    protected $CustomerAccountType = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return CustomerAccountType[]
     */
    public function getCustomerAccountType()
    {
      return $this->CustomerAccountType;
    }

    /**
     * @param CustomerAccountType[] $CustomerAccountType
     * @return \Eurostop\Loyalty\ArrayOfCustomerAccountType
     */
    public function setCustomerAccountType(array $CustomerAccountType = null)
    {
      $this->CustomerAccountType = $CustomerAccountType;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->CustomerAccountType[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return CustomerAccountType
     */
    public function offsetGet($offset)
    {
      return $this->CustomerAccountType[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param CustomerAccountType $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->CustomerAccountType[] = $value;
      } else {
        $this->CustomerAccountType[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->CustomerAccountType[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return CustomerAccountType Return the current element
     */
    public function current()
    {
      return current($this->CustomerAccountType);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->CustomerAccountType);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->CustomerAccountType);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->CustomerAccountType);
    }

    /**
     * Countable implementation
     *
     * @return CustomerAccountType Return count of elements
     */
    public function count()
    {
      return count($this->CustomerAccountType);
    }

}
