<?php

namespace Eurostop\Fulfilment;

class SubmitCustomerOrderStockSources
{

    /**
     * @var ArrayOfSubmittedCustomerOrderStockSource $customerOrderStockSources
     */
    protected $customerOrderStockSources = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedCustomerOrderStockSource $customerOrderStockSources
     * @param string $submissionReference
     */
    public function __construct($customerOrderStockSources, $submissionReference)
    {
      $this->customerOrderStockSources = $customerOrderStockSources;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedCustomerOrderStockSource
     */
    public function getCustomerOrderStockSources()
    {
      return $this->customerOrderStockSources;
    }

    /**
     * @param ArrayOfSubmittedCustomerOrderStockSource $customerOrderStockSources
     * @return \Eurostop\Fulfilment\SubmitCustomerOrderStockSources
     */
    public function setCustomerOrderStockSources($customerOrderStockSources)
    {
      $this->customerOrderStockSources = $customerOrderStockSources;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Fulfilment\SubmitCustomerOrderStockSources
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
