<?php

namespace Eurostop\Fulfilment;

class SubmitCustomerOrderActions
{

    /**
     * @var ArrayOfSubmittedCustomerOrderAction $customerOrderActions
     */
    protected $customerOrderActions = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedCustomerOrderAction $customerOrderActions
     * @param string $submissionReference
     */
    public function __construct($customerOrderActions, $submissionReference)
    {
      $this->customerOrderActions = $customerOrderActions;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedCustomerOrderAction
     */
    public function getCustomerOrderActions()
    {
      return $this->customerOrderActions;
    }

    /**
     * @param ArrayOfSubmittedCustomerOrderAction $customerOrderActions
     * @return \Eurostop\Fulfilment\SubmitCustomerOrderActions
     */
    public function setCustomerOrderActions($customerOrderActions)
    {
      $this->customerOrderActions = $customerOrderActions;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Fulfilment\SubmitCustomerOrderActions
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
