<?php

namespace Eurostop\Fulfilment;

class GetCustomerOrdersByStatus
{

    /**
     * @var \DateTime $fromDate
     */
    protected $fromDate = null;

    /**
     * @var \DateTime $toDate
     */
    protected $toDate = null;

    /**
     * @var ArrayOfCustomerOrderStatus $orderStatuses
     */
    protected $orderStatuses = null;

    /**
     * @var ArrayOfCustomerOrderFulfilmentPlanStatus $planStatuses
     */
    protected $planStatuses = null;

    /**
     * @var ArrayOfCustomerOrderItemPlanStatus $itemStatuses
     */
    protected $itemStatuses = null;

    /**
     * @var ArrayOfCustomerOrderItemPickStatus $pickStatuses
     */
    protected $pickStatuses = null;

    /**
     * @var ArrayOfCustomerOrderItemPackStatus $packStatuses
     */
    protected $packStatuses = null;

    /**
     * @var int $maxCustomerOrders
     */
    protected $maxCustomerOrders = null;

    /**
     * @param \DateTime $fromDate
     * @param \DateTime $toDate
     * @param ArrayOfCustomerOrderStatus $orderStatuses
     * @param ArrayOfCustomerOrderFulfilmentPlanStatus $planStatuses
     * @param ArrayOfCustomerOrderItemPlanStatus $itemStatuses
     * @param ArrayOfCustomerOrderItemPickStatus $pickStatuses
     * @param ArrayOfCustomerOrderItemPackStatus $packStatuses
     * @param int $maxCustomerOrders
     */
    public function __construct(\DateTime $fromDate, \DateTime $toDate, $orderStatuses, $planStatuses, $itemStatuses, $pickStatuses, $packStatuses, $maxCustomerOrders)
    {
      $this->fromDate = $fromDate->format(\DateTime::ATOM);
      $this->toDate = $toDate->format(\DateTime::ATOM);
      $this->orderStatuses = $orderStatuses;
      $this->planStatuses = $planStatuses;
      $this->itemStatuses = $itemStatuses;
      $this->pickStatuses = $pickStatuses;
      $this->packStatuses = $packStatuses;
      $this->maxCustomerOrders = $maxCustomerOrders;
    }

    /**
     * @return \DateTime
     */
    public function getFromDate()
    {
      if ($this->fromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->fromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $fromDate
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByStatus
     */
    public function setFromDate(\DateTime $fromDate)
    {
      $this->fromDate = $fromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getToDate()
    {
      if ($this->toDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->toDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $toDate
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByStatus
     */
    public function setToDate(\DateTime $toDate)
    {
      $this->toDate = $toDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return ArrayOfCustomerOrderStatus
     */
    public function getOrderStatuses()
    {
      return $this->orderStatuses;
    }

    /**
     * @param ArrayOfCustomerOrderStatus $orderStatuses
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByStatus
     */
    public function setOrderStatuses($orderStatuses)
    {
      $this->orderStatuses = $orderStatuses;
      return $this;
    }

    /**
     * @return ArrayOfCustomerOrderFulfilmentPlanStatus
     */
    public function getPlanStatuses()
    {
      return $this->planStatuses;
    }

    /**
     * @param ArrayOfCustomerOrderFulfilmentPlanStatus $planStatuses
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByStatus
     */
    public function setPlanStatuses($planStatuses)
    {
      $this->planStatuses = $planStatuses;
      return $this;
    }

    /**
     * @return ArrayOfCustomerOrderItemPlanStatus
     */
    public function getItemStatuses()
    {
      return $this->itemStatuses;
    }

    /**
     * @param ArrayOfCustomerOrderItemPlanStatus $itemStatuses
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByStatus
     */
    public function setItemStatuses($itemStatuses)
    {
      $this->itemStatuses = $itemStatuses;
      return $this;
    }

    /**
     * @return ArrayOfCustomerOrderItemPickStatus
     */
    public function getPickStatuses()
    {
      return $this->pickStatuses;
    }

    /**
     * @param ArrayOfCustomerOrderItemPickStatus $pickStatuses
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByStatus
     */
    public function setPickStatuses($pickStatuses)
    {
      $this->pickStatuses = $pickStatuses;
      return $this;
    }

    /**
     * @return ArrayOfCustomerOrderItemPackStatus
     */
    public function getPackStatuses()
    {
      return $this->packStatuses;
    }

    /**
     * @param ArrayOfCustomerOrderItemPackStatus $packStatuses
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByStatus
     */
    public function setPackStatuses($packStatuses)
    {
      $this->packStatuses = $packStatuses;
      return $this;
    }

    /**
     * @return int
     */
    public function getMaxCustomerOrders()
    {
      return $this->maxCustomerOrders;
    }

    /**
     * @param int $maxCustomerOrders
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByStatus
     */
    public function setMaxCustomerOrders($maxCustomerOrders)
    {
      $this->maxCustomerOrders = $maxCustomerOrders;
      return $this;
    }

}
