<?php

namespace Eurostop\Fulfilment;

class CustomerAddress extends RetrievedDataItemOfCustomerAddressDtoKJ8WzcEX
{

    /**
     * @var string $Address1
     */
    protected $Address1 = null;

    /**
     * @var string $Address2
     */
    protected $Address2 = null;

    /**
     * @var string $Address3
     */
    protected $Address3 = null;

    /**
     * @var string $Address4
     */
    protected $Address4 = null;

    /**
     * @var string $Address5
     */
    protected $Address5 = null;

    /**
     * @var string $AddressIdentifier
     */
    protected $AddressIdentifier = null;

    /**
     * @var string $CountryIdentifier
     */
    protected $CountryIdentifier = null;

    /**
     * @var string $CountyState
     */
    protected $CountyState = null;

    /**
     * @var string $CustomerIdentifier
     */
    protected $CustomerIdentifier = null;

    /**
     * @var string $PostCodeZip
     */
    protected $PostCodeZip = null;

    /**
     * @var boolean $PrimaryAddress
     */
    protected $PrimaryAddress = null;

    /**
     * @var string $RecipientName
     */
    protected $RecipientName = null;

    /**
     * @param boolean $PrimaryAddress
     */
    public function __construct($PrimaryAddress)
    {
      parent::__construct();
      $this->PrimaryAddress = $PrimaryAddress;
    }

    /**
     * @return string
     */
    public function getAddress1()
    {
      return $this->Address1;
    }

    /**
     * @param string $Address1
     * @return \Eurostop\Fulfilment\CustomerAddress
     */
    public function setAddress1($Address1)
    {
      $this->Address1 = $Address1;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddress2()
    {
      return $this->Address2;
    }

    /**
     * @param string $Address2
     * @return \Eurostop\Fulfilment\CustomerAddress
     */
    public function setAddress2($Address2)
    {
      $this->Address2 = $Address2;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddress3()
    {
      return $this->Address3;
    }

    /**
     * @param string $Address3
     * @return \Eurostop\Fulfilment\CustomerAddress
     */
    public function setAddress3($Address3)
    {
      $this->Address3 = $Address3;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddress4()
    {
      return $this->Address4;
    }

    /**
     * @param string $Address4
     * @return \Eurostop\Fulfilment\CustomerAddress
     */
    public function setAddress4($Address4)
    {
      $this->Address4 = $Address4;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddress5()
    {
      return $this->Address5;
    }

    /**
     * @param string $Address5
     * @return \Eurostop\Fulfilment\CustomerAddress
     */
    public function setAddress5($Address5)
    {
      $this->Address5 = $Address5;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressIdentifier()
    {
      return $this->AddressIdentifier;
    }

    /**
     * @param string $AddressIdentifier
     * @return \Eurostop\Fulfilment\CustomerAddress
     */
    public function setAddressIdentifier($AddressIdentifier)
    {
      $this->AddressIdentifier = $AddressIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getCountryIdentifier()
    {
      return $this->CountryIdentifier;
    }

    /**
     * @param string $CountryIdentifier
     * @return \Eurostop\Fulfilment\CustomerAddress
     */
    public function setCountryIdentifier($CountryIdentifier)
    {
      $this->CountryIdentifier = $CountryIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getCountyState()
    {
      return $this->CountyState;
    }

    /**
     * @param string $CountyState
     * @return \Eurostop\Fulfilment\CustomerAddress
     */
    public function setCountyState($CountyState)
    {
      $this->CountyState = $CountyState;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerIdentifier()
    {
      return $this->CustomerIdentifier;
    }

    /**
     * @param string $CustomerIdentifier
     * @return \Eurostop\Fulfilment\CustomerAddress
     */
    public function setCustomerIdentifier($CustomerIdentifier)
    {
      $this->CustomerIdentifier = $CustomerIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getPostCodeZip()
    {
      return $this->PostCodeZip;
    }

    /**
     * @param string $PostCodeZip
     * @return \Eurostop\Fulfilment\CustomerAddress
     */
    public function setPostCodeZip($PostCodeZip)
    {
      $this->PostCodeZip = $PostCodeZip;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getPrimaryAddress()
    {
      return $this->PrimaryAddress;
    }

    /**
     * @param boolean $PrimaryAddress
     * @return \Eurostop\Fulfilment\CustomerAddress
     */
    public function setPrimaryAddress($PrimaryAddress)
    {
      $this->PrimaryAddress = $PrimaryAddress;
      return $this;
    }

    /**
     * @return string
     */
    public function getRecipientName()
    {
      return $this->RecipientName;
    }

    /**
     * @param string $RecipientName
     * @return \Eurostop\Fulfilment\CustomerAddress
     */
    public function setRecipientName($RecipientName)
    {
      $this->RecipientName = $RecipientName;
      return $this;
    }

}
