<?php

namespace Eurostop\Fulfilment;

class ArrayOfCustomerOrder implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var CustomerOrder[] $CustomerOrder
     */
    protected $CustomerOrder = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return CustomerOrder[]
     */
    public function getCustomerOrder()
    {
      return $this->CustomerOrder;
    }

    /**
     * @param CustomerOrder[] $CustomerOrder
     * @return \Eurostop\Fulfilment\ArrayOfCustomerOrder
     */
    public function setCustomerOrder(array $CustomerOrder = null)
    {
      $this->CustomerOrder = $CustomerOrder;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->CustomerOrder[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return CustomerOrder
     */
    public function offsetGet($offset)
    {
      return $this->CustomerOrder[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param CustomerOrder $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->CustomerOrder[] = $value;
      } else {
        $this->CustomerOrder[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->CustomerOrder[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return CustomerOrder Return the current element
     */
    public function current()
    {
      return current($this->CustomerOrder);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->CustomerOrder);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->CustomerOrder);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->CustomerOrder);
    }

    /**
     * Countable implementation
     *
     * @return CustomerOrder Return count of elements
     */
    public function count()
    {
      return count($this->CustomerOrder);
    }

}
