<?php

/*
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

/**
 * requires "wsdl2phpgenerator/wsdl2phpgenerator": "^3.0"
 * added to the composer.json
 */


require_once __DIR__ . '/../vendor/autoload.php';


class EurostopBuilder {

    
    public static function buildSecurity($baseUrl, $dir, $proxy = null) {
        # Add security endpoints
        $endpoints = ['security'];
        self::doBuild($endpoints, $baseUrl, $dir, $proxy);
        return;
    }
    

    public static function buildLib($baseUrl, $dir, $username, $password, $proxy = null) {
        $endpoints = ['organisation', 'products', 'stocks', 'fulfilment', 'loyalty', 'sales', 'status'];
        $token = self::doLogin($username, $password);
        self::doBuild($endpoints, $baseUrl, $dir, $proxy, $token);
        return;
    }

    

    protected static function doLogin($username, $password) {
        $lgInter = new \Eurostop\Security\SecurityWebServiceInterfacePlugin(['soap_version' => SOAP_1_2]);
        $login = new \Eurostop\Security\Login($username, $password);
        $loggedIn = $lgInter->Login($login);
        return $loggedIn->getLoginResult()->getAuthToken();
    }


    protected static function doBuild($endpoints, $baseUrl, $dir, $proxy, $token = null) {

        foreach ($endpoints as $endpoint) {

            $config = [];
            $config['inputFile'] = $baseUrl . $endpoint . '?wsdl';
            $config['outputDir'] = $dir .'/'. ucfirst($endpoint);
            $config['namespaceName'] = 'Eurostop\\' . ucfirst($endpoint);
            $config['constructorParamsDefaultToNull'] = true;

            if ($token) {
                $config['soapClientOptions'] = ['stream_context' => stream_context_create(['http' => ['header' => 'AuthToken: ' . $token]])];
            }
            if ($proxy) {
                $config['proxy'] = 'tcp://' . $proxy;
            }

            $generator = new \Wsdl2PhpGenerator\Generator();
            $generator->generate(
                    new \Wsdl2PhpGenerator\Config($config)
            );
        }
        return;
    }
  
    /**
     * 
     * usage 
     * php -r 'include "EurostopBuilder.php"; EurostopBuilder::securitySetup("https://retailtest.trotters.co.uk:6500/e-interface/", "Eurostop", "demo.talisman-innovations.com", 8888);'
     * 
     * @param string $baseUrl 'https://retailtest.trotters.co.uk:6500/e-interface/'
     * @param string $dir 'Eurostop'
     * @param string $proxy 'demo.talisman-innovations.com'
     * @param int $proxyPort  8888
     */
    public function securitySetup($baseUrl, $dir, $proxy = null, $proxyPort = null) { 
        $proxy = ($proxy)?$proxy . ':' . $proxyPort: null;
        self::buildSecurity($baseUrl, $dir, $proxy);
        exit;
    }
    
    /**
     * 
     * usage 
     * php -r 'include "EurostopBuilder.php"; EurostopBuilder::libSetup("https://retailtest.trotters.co.uk:6500/e-interface/", "Eurostop", "Shopify", "test", "demo.talisman-innovations.com", 8888);'
     * 
     * @param string $baseUrl 'https://retailtest.trotters.co.uk:6500/e-interface/'
     * @param string $dir 'Eurostop'
     * @param string $username 'Shopify'
     * @param string $password 'test'
     * @param string $proxy 'demo.talisman-innovations.com'
     * @param int $proxyPort  8888
     */
    public function libSetup($baseUrl, $dir, $username, $password, $proxy = null, $proxyPort = null) {
        $proxy = ($proxy)?$proxy . ':' . $proxyPort: null;
        self::buildLib($baseUrl, $dir, $username, $password, $proxy);       
        exit;
    }
}
