<?php

namespace Eurostop\Stocks;

class SubmitDeliveries
{

    /**
     * @var ArrayOfSubmittedDeliveryLine $deliveryLines
     */
    protected $deliveryLines = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedDeliveryLine $deliveryLines
     * @param string $submissionReference
     */
    public function __construct($deliveryLines = null, $submissionReference = null)
    {
      $this->deliveryLines = $deliveryLines;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedDeliveryLine
     */
    public function getDeliveryLines()
    {
      return $this->deliveryLines;
    }

    /**
     * @param ArrayOfSubmittedDeliveryLine $deliveryLines
     * @return \Eurostop\Stocks\SubmitDeliveries
     */
    public function setDeliveryLines($deliveryLines)
    {
      $this->deliveryLines = $deliveryLines;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitDeliveries
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
