<?php

namespace Eurostop\Stocks;

class GetDeliveriesByPurchaseOrder
{

    /**
     * @var string $purchaseOrderIdentifier
     */
    protected $purchaseOrderIdentifier = null;

    /**
     * @var PurchaseOrderIdentifierType $purchaseOrderIdentifierType
     */
    protected $purchaseOrderIdentifierType = null;

    /**
     * @var boolean $includeUnConfirmed
     */
    protected $includeUnConfirmed = null;

    /**
     * @param string $purchaseOrderIdentifier
     * @param PurchaseOrderIdentifierType $purchaseOrderIdentifierType
     * @param boolean $includeUnConfirmed
     */
    public function __construct($purchaseOrderIdentifier = null, $purchaseOrderIdentifierType = null, $includeUnConfirmed = null)
    {
      $this->purchaseOrderIdentifier = $purchaseOrderIdentifier;
      $this->purchaseOrderIdentifierType = $purchaseOrderIdentifierType;
      $this->includeUnConfirmed = $includeUnConfirmed;
    }

    /**
     * @return string
     */
    public function getPurchaseOrderIdentifier()
    {
      return $this->purchaseOrderIdentifier;
    }

    /**
     * @param string $purchaseOrderIdentifier
     * @return \Eurostop\Stocks\GetDeliveriesByPurchaseOrder
     */
    public function setPurchaseOrderIdentifier($purchaseOrderIdentifier)
    {
      $this->purchaseOrderIdentifier = $purchaseOrderIdentifier;
      return $this;
    }

    /**
     * @return PurchaseOrderIdentifierType
     */
    public function getPurchaseOrderIdentifierType()
    {
      return $this->purchaseOrderIdentifierType;
    }

    /**
     * @param PurchaseOrderIdentifierType $purchaseOrderIdentifierType
     * @return \Eurostop\Stocks\GetDeliveriesByPurchaseOrder
     */
    public function setPurchaseOrderIdentifierType($purchaseOrderIdentifierType)
    {
      $this->purchaseOrderIdentifierType = $purchaseOrderIdentifierType;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeUnConfirmed()
    {
      return $this->includeUnConfirmed;
    }

    /**
     * @param boolean $includeUnConfirmed
     * @return \Eurostop\Stocks\GetDeliveriesByPurchaseOrder
     */
    public function setIncludeUnConfirmed($includeUnConfirmed)
    {
      $this->includeUnConfirmed = $includeUnConfirmed;
      return $this;
    }

}
